/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;

public class TomeAbyssBase
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    public static final IntegerProperty suppliedLeather = IntegerProperty.create((String)"supplied_leather", (int)0, (int)2);
    public static final IntegerProperty suppliedParchment = IntegerProperty.create((String)"supplied_parchment", (int)0, (int)4);

    public TomeAbyssBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)suppliedLeather, (Comparable)Integer.valueOf(0))).setValue((Property)suppliedParchment, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{suppliedLeather});
        builder.add(new Property[]{suppliedParchment});
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int searchRadius;
            boolean foundEssence;
            int currentLeatherValue = (Integer)level.getBlockState(pos).getValue((Property)suppliedLeather);
            int currentParchmentValue = (Integer)level.getBlockState(pos).getValue((Property)suppliedParchment);
            ItemStack mainHandItem = player.getMainHandItem();
            if (mainHandItem.is(Items.LEATHER) && currentLeatherValue < 2) {
                mainHandItem.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)suppliedLeather, (Comparable)Integer.valueOf(currentLeatherValue + 1)));
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (mainHandItem.is(AbyssTechItems.PARCHMENT) && currentParchmentValue < 4) {
                mainHandItem.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)suppliedParchment, (Comparable)Integer.valueOf(currentParchmentValue + 1)));
                level.playSound(null, pos, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (mainHandItem.is(AbyssTechTags.Items.BIG_BOOK_LIKE) && currentLeatherValue == 2 && currentParchmentValue == 4 && (foundEssence = AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius = 4, 50, 20))) {
                mainHandItem.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)((Block)AbyssTechBlocks.TOME_ABYSS.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)FACING))));
                level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(null, pos, AbyssTechSounds.MIRROR_TUNE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

