/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class TuningCrystal
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty model = IntegerProperty.create((String)"model", (int)0, (int)3);
    public static final BooleanProperty upgraded = BooleanProperty.create((String)"upgraded");

    public TuningCrystal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)upgraded, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        int stateToPlace = 0;
        Level level = context.getLevel();
        if (level.getBlockState((pos = context.getClickedPos()).below(1)).is((Block)AbyssTechBlocks.INSTABILITY_STABILIZER.get()) || level.getBlockState(pos.above(1)).isAir() && level.getBlockState(pos.below(1)).isAir()) {
            stateToPlace = 3;
        } else if (!level.getBlockState(pos.above(1)).isAir()) {
            stateToPlace = !level.getBlockState(pos.below(1)).isAir() ? 2 : 1;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)model, (Comparable)Integer.valueOf(stateToPlace));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{model});
        builder.add(new Property[]{upgraded});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getMainHandItem().is(AbyssTechItems.THRESHOLD_GEAR) && !((Boolean)level.getBlockState(pos).getValue((Property)upgraded)).booleanValue()) {
            player.getMainHandItem().shrink(1);
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)upgraded, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, AbyssTechSounds.WRENCH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block currentBlock = level.getBlockState(pos).getBlock();
        Block[] validBlocks = new Block[]{(Block)AbyssTechBlocks.TUNING_CRYSTAL_FLOW.get(), (Block)AbyssTechBlocks.TUNING_CRYSTAL_VIGOR.get(), (Block)AbyssTechBlocks.TUNING_CRYSTAL_EMBRACE.get()};
        SimpleParticleType[] particleToSpawn = new SimpleParticleType[]{ParticleTypes.HAPPY_VILLAGER, ParticleTypes.FLAME, ParticleTypes.WITCH};
        for (int i = 0; i < validBlocks.length; ++i) {
            if (currentBlock != validBlocks[i]) continue;
            level.sendParticles((ParticleOptions)particleToSpawn[i], (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 4, (double)0.2f, (double)0.2f, (double)0.2f, 0.0);
        }
        super.randomTick(state, level, pos, random);
    }
}

