/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.XpMachineBlockEntity;
import org.jetbrains.annotations.Nullable;

public class XpMachine
extends BaseEntityBlock {
    public static final MapCodec<XpMachine> CODEC = XpMachine.simpleCodec(XpMachine::new);
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public XpMachine(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new XpMachineBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof XpMachineBlockEntity) {
            XpMachineBlockEntity xpMachineBlockEntity = (XpMachineBlockEntity)blockEntity;
            int playerXP = player.totalExperience;
            int currentMachineXp = xpMachineBlockEntity.getXpAmount();
            int takeGiveXpAmount = 20;
            int machineMaxXpAmount = xpMachineBlockEntity.getMaxXpAmount();
            if (!player.isShiftKeyDown()) {
                if (playerXP > 0) {
                    if (currentMachineXp + takeGiveXpAmount > machineMaxXpAmount) {
                        takeGiveXpAmount = machineMaxXpAmount - currentMachineXp;
                    }
                    if (playerXP >= takeGiveXpAmount) {
                        player.giveExperiencePoints(-takeGiveXpAmount);
                        xpMachineBlockEntity.addXpAmount(takeGiveXpAmount);
                    } else {
                        player.giveExperiencePoints(-playerXP);
                        xpMachineBlockEntity.addXpAmount(playerXP);
                    }
                }
                level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 0.0f);
            } else if (currentMachineXp > 0) {
                if (currentMachineXp - takeGiveXpAmount < 0) {
                    takeGiveXpAmount = currentMachineXp;
                }
                player.giveExperiencePoints(takeGiveXpAmount);
                xpMachineBlockEntity.addXpAmount(-takeGiveXpAmount);
                level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return XpMachine.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.XP_MACHINE_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

