/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.AbyssMirror;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;

public class AbyssMirrorBlockEntity
extends BlockEntity {
    protected int[] targetLoc = new int[]{0, 0, 0};
    private int cooldown = 0;

    public AbyssMirrorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ABYSS_MIRROR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.targetLoc[0] = pTag.getInt("mirror.tar_x");
        this.targetLoc[1] = pTag.getInt("mirror.tar_y");
        this.targetLoc[2] = pTag.getInt("mirror.tar_z");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("mirror.tar_x", this.targetLoc[0]);
        pTag.putInt("mirror.tar_y", this.targetLoc[1]);
        pTag.putInt("mirror.tar_z", this.targetLoc[2]);
        super.saveAdditional(pTag, pRegistries);
    }

    public void tick(Level level, BlockPos pPos, BlockState state) {
        if (!level.isClientSide() && state.getValue((Property)AbyssMirror.SEGMENT) == MultiBlockSegment.BOTTOM && ((Boolean)level.getBlockState(pPos).getValue((Property)AbyssMirror.collidingCooldown)).booleanValue()) {
            ++this.cooldown;
            if (this.cooldown >= 60) {
                level.setBlockAndUpdate(pPos, (BlockState)level.getBlockState(pPos).setValue((Property)AbyssMirror.collidingCooldown, (Comparable)Boolean.valueOf(false)));
                this.cooldown = 0;
            }
        }
    }
}

