/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssRFGen;
import net.quasar.abysstech.block.custom.AbyssalEngine;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.energy.AbyssTechEnergyStorage;
import net.quasar.abysstech.block.entity.energy.AbyssTechEnergyUtil;
import org.jetbrains.annotations.Nullable;

public class AbyssRFGenBlockEntity
extends AbstractEssenceMachine {
    private int maxEnergy = 1000000;
    private final AbyssTechEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final Random random = new Random();
    private int warmup = 0;
    private int maxWarmup = 10000;
    private int renderTick = 0;
    private float[] renderTransform = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public AbyssRFGenBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ABYSS_RF_GEN_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    private AbyssTechEnergyStorage createEnergyStorage() {
        return new AbyssTechEnergyStorage(this.maxEnergy, 100000){

            @Override
            public void onEnergyChanged() {
                AbyssRFGenBlockEntity.this.setChanged();
                AbyssRFGenBlockEntity.this.getLevel().sendBlockUpdated(AbyssRFGenBlockEntity.this.getBlockPos(), AbyssRFGenBlockEntity.this.getBlockState(), AbyssRFGenBlockEntity.this.getBlockState(), 3);
            }
        };
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("abyss_rf_gen.energy", this.ENERGY_STORAGE.getEnergyStored());
        tag.putInt("abyss_rf_gen.warmup", this.warmup);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.ENERGY_STORAGE.setEnergy(tag.getInt("abyss_rf_gen.energy"));
        this.warmup = tag.getInt("abyss_rf_gen.warmup");
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    private void addEnergy(int amount) {
        this.ENERGY_STORAGE.receiveEnergy(amount, false);
    }

    private void pushEnergyHorizontalSides() {
        if (this.level != null) {
            BlockPos[] direction = new BlockPos[]{this.worldPosition.north(), this.worldPosition.south(), this.worldPosition.east(), this.worldPosition.west()};
            for (int i = 0; i < direction.length; ++i) {
                if (!AbyssTechEnergyUtil.doesBlockHaveEnergyStorage(direction[i], this.level)) continue;
                AbyssTechEnergyUtil.move(this.worldPosition, direction[i], 25000, this.level);
            }
        }
    }

    public float[] rendererTranslation() {
        if (this.renderTick > this.random.nextInt(1, 6)) {
            this.renderTick = 0;
            for (int i = 0; i < this.renderTransform.length; ++i) {
                this.renderTransform[i] = (float)(this.random.nextInt(8) - 4) * 0.01f;
            }
        }
        ++this.renderTick;
        return this.renderTransform;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide() && state.getValue((Property)AbyssRFGen.SEGMENT) == MultiBlockSegment.BOTTOM) {
            boolean essenceFound;
            boolean bl = level.getBlockState(pos.below(1)).is(AbyssTechBlocks.ABYSSAL_ENGINE) ? (((Boolean)level.getBlockState(pos.below(1)).getValue((Property)AbyssalEngine.hasTube)).booleanValue() ? this.searchTakeEssence(level, pos, 2, 1) : this.searchTakeEssence(level, pos, 2, 1, 1)) : (essenceFound = false);
            if (essenceFound) {
                if (this.warmup < this.maxWarmup) {
                    ++this.warmup;
                }
                int powerMultiplier = this.warmup < 1000 ? 1 : (this.warmup < 3000 ? 2 : (this.warmup < 8000 ? 4 : (this.warmup < 9000 ? 6 : 10)));
                int powerDivider = (Boolean)level.getBlockState(pos.below(1)).getValue((Property)AbyssalEngine.hasTube) != false ? 1 : 2;
                this.addEnergy(this.warmup * powerMultiplier / powerDivider);
            } else {
                this.warmup = this.warmup > 50 ? this.warmup - 50 : 0;
            }
            this.pushEnergyHorizontalSides();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getWarmup() {
        return this.warmup;
    }

    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    public int getMaxWarmup() {
        return this.maxWarmup;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }
}

