/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.AbyssalTome;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.util.special_recipe.AbyssTechRecipes;
import net.quasar.abysstech.util.special_recipe.AbyssTomeRecipe;
import org.jetbrains.annotations.Nullable;

public class AbyssalTomeBlockEntity
extends AbstractEssenceMachine
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final Random random = new Random();
    private final int maxCraftTicks = 10;
    private int craftTick = 0;
    private final int tickRate = 5;
    private int tickCounter = this.random.nextInt(0, 4);
    private float itemRotation = 0.0f;
    private float itemBob = 0.0f;
    private boolean itemBobRising = true;

    public AbyssalTomeBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ABYSSAL_TOME_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty();
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            if (this.tickCounter >= 5) {
                this.tickCounter = 0;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof AbyssalTomeBlockEntity) {
                    AbyssalTomeBlockEntity tome = (AbyssalTomeBlockEntity)blockEntity;
                    if (((Boolean)state.getValue((Property)AbyssalTome.hasItem)).booleanValue()) {
                        if (tome.isEmpty()) {
                            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AbyssalTome.hasItem, (Comparable)Boolean.valueOf(false)));
                        }
                    } else if (!((Boolean)state.getValue((Property)AbyssalTome.hasItem)).booleanValue() && !tome.isEmpty()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AbyssalTome.hasItem, (Comparable)Boolean.valueOf(true)));
                    }
                    if (((Boolean)state.getValue((Property)AbyssalTome.clicked)).booleanValue() || level.getBestNeighborSignal(pos) > 0 && !((Boolean)state.getValue((Property)AbyssalTome.isCrafting)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)AbyssalTome.isCrafting, (Comparable)Boolean.valueOf(true))).setValue((Property)AbyssalTome.clicked, (Comparable)Boolean.valueOf(false)));
                    }
                    if (((Boolean)state.getValue((Property)AbyssalTome.isCrafting)).booleanValue()) {
                        BlockPos[] pedestalPos = new BlockPos[]{pos.offset(1, 0, 1), pos.offset(1, 0, -1), pos.offset(-1, 0, 1), pos.offset(-1, 0, -1)};
                        ArrayList<SingleItemContainerBlockEntity> pedestals = new ArrayList<SingleItemContainerBlockEntity>();
                        for (BlockPos offPos : pedestalPos) {
                            if (!(level.getBlockEntity(offPos) instanceof SingleItemContainerBlockEntity)) {
                                pedestals.clear();
                                break;
                            }
                            pedestals.add((SingleItemContainerBlockEntity)level.getBlockEntity(offPos));
                        }
                        if (!pedestals.isEmpty()) {
                            if (this.searchTakeEssence(level, pos, 2, 1)) {
                                ++this.craftTick;
                                this.pedestalParticles(level, pos, pedestalPos, AbyssTechParticles.UNSTABLE_PARTICLES.get(), false);
                                if (this.craftTick >= 10) {
                                    ArrayList<Item> sacIngredients = new ArrayList<Item>();
                                    for (SingleItemContainerBlockEntity pedestal : pedestals) {
                                        sacIngredients.add(pedestal.getItem(0).getItem());
                                    }
                                    Item result = this.sacRec(sacIngredients.toArray(new Item[0]));
                                    if (result != null && tome.isEmpty()) {
                                        for (SingleItemContainerBlockEntity pedestal : pedestals) {
                                            pedestal.clearContent();
                                        }
                                        tome.setItem(0, result.getDefaultInstance());
                                        this.pedestalParticles(level, pos, pedestalPos, AbyssTechParticles.STRANGE_FLAME.get(), true);
                                    }
                                    this.resetState(level, pos, state);
                                }
                            } else {
                                this.resetState(level, pos, state);
                            }
                        } else {
                            this.resetState(level, pos, state);
                        }
                    } else if (this.craftTick > 0) {
                        this.craftTick = 0;
                    }
                }
            }
            ++this.tickCounter;
        }
    }

    private Item sacRec(Item[] ingredients) {
        List<AbyssTomeRecipe> tomeRecList = AbyssTechRecipes.getAllRecipesOfType(AbyssTomeRecipe.class);
        for (AbyssTomeRecipe abyssTomeRecipe : tomeRecList) {
            ArrayList<Item> toIterate = new ArrayList<Item>(Arrays.asList(abyssTomeRecipe.getInput()));
            int matches = 0;
            for (int i = 0; i < ingredients.length; ++i) {
                for (int m = 0; m < toIterate.size(); ++m) {
                    if (!ingredients[i].getDefaultInstance().is((Item)toIterate.get(m))) continue;
                    toIterate.remove(m);
                    ++matches;
                    break;
                }
                if (matches < 4) continue;
                return abyssTomeRecipe.getOutput();
            }
        }
        return null;
    }

    private void resetState(Level level, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AbyssalTome.isCrafting, (Comparable)Boolean.valueOf(false)));
        this.tickCounter = 0;
    }

    private void pedestalParticles(Level level, BlockPos centerPos, BlockPos[] posArray, SimpleParticleType particle, Boolean finishingEffects) {
        for (BlockPos pos : posArray) {
            ((ServerLevel)level).sendParticles((ParticleOptions)particle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.2f), (double)((float)pos.getZ() + 0.5f), finishingEffects != false ? 6 : 1, finishingEffects != false ? (double)0.3f : 0.0, finishingEffects != false ? (double)0.3f : 0.0, finishingEffects != false ? (double)0.3f : 0.0, 0.0);
        }
        if (finishingEffects.booleanValue()) {
            level.playSound(null, centerPos, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.BLOCKS);
        }
    }

    public float rotateRenderedItem() {
        this.itemRotation += 0.5f;
        if (this.itemRotation > 360.0f) {
            this.itemRotation = 0.0f;
        }
        return this.itemRotation;
    }

    public float bobRenderedItem() {
        float slow = this.itemBob < 0.05f || this.itemBob > 0.1f ? (this.itemBob < 0.03f || this.itemBob > 0.12f ? (this.itemBob < 0.01f || this.itemBob > 0.14f ? 0.001f : 0.002f) : 0.003f) : 0.004f;
        this.itemBob = this.itemBobRising ? this.itemBob + slow : this.itemBob - slow;
        this.itemBobRising = !(this.itemBob > 0.15f) && (this.itemBob < 0.0f || this.itemBobRising);
        return this.itemBob;
    }
}

