/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.Alembic;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class AlembicBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private int alembicProgress = 0;
    private static final Map<Item, Item> DISTILATION_MAP = Map.ofEntries(Map.entry((Item)AbyssTechItems.TORPOR_CAP_FERMENTED.get(), AbyssTechItems.DISTILLATE_TORPOR.asItem()), Map.entry((Item)AbyssTechItems.SOL_MOREL_FERMENTED.get(), AbyssTechItems.DISTILLATE_SOL.asItem()), Map.entry((Item)AbyssTechItems.CREEPING_MOREL_FERMENTED.get(), AbyssTechItems.DISTILLATE_CREEPING.asItem()), Map.entry((Item)AbyssTechItems.GUT_PUFFBALL_FERMENTED.get(), AbyssTechItems.DISTILLATE_GUT.asItem()), Map.entry((Item)AbyssTechItems.MUSH_PUFFBALL_FERMENTED.get(), AbyssTechItems.DISTILLATE_MUSH.asItem()), Map.entry((Item)AbyssTechItems.WEEPING_CAP_FERMENTED.get(), AbyssTechItems.DISTILLATE_WEEPING.asItem()), Map.entry((Item)AbyssTechItems.VIBRANT_WHEAT_FERMENTED.get(), (Item)AbyssTechItems.DISTILLATE_VIBRANT.get()), Map.entry((Item)AbyssTechItems.ROYAL_HONEY_FERMENTED.get(), (Item)AbyssTechItems.DISTILLATE_ROYAL.get()));
    Random random = new Random();
    private final int tickRate = 60;
    private int currentTick = this.random.nextInt(0, 59);

    public AlembicBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ALEMBIC_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty() && DISTILATION_MAP.containsValue(stack.getItem());
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("abyssal_alembic.progress", this.alembicProgress);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.alembicProgress = tag.getInt("abyssal_alembic.progress");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    private void chamberInPlace(Level level, BlockPos pos, BlockPos mixerPos) {
        BlockEntity blockEntity = level.getBlockEntity(mixerPos);
        if (blockEntity instanceof SingleItemContainerBlockEntity) {
            SingleItemContainerBlockEntity chamberBelow = (SingleItemContainerBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AlembicBlockEntity) {
                AlembicBlockEntity alembic = (AlembicBlockEntity)blockEntity;
                boolean validProgress = false;
                if (!alembic.isEmpty() && (level.getBlockState(pos.below()).is(Blocks.CAMPFIRE) || level.getBlockState(pos.below()).is(Blocks.SOUL_CAMPFIRE)) && DISTILATION_MAP.containsKey(alembic.getItem(0).getItem()) && chamberBelow.isEmpty()) {
                    int maxProgress;
                    ++this.alembicProgress;
                    AbyssTechUtility.sendSimpleEffects(level, pos, 2, 1.2, ParticleTypes.BUBBLE, AbyssTechSounds.DISTILLING.get());
                    validProgress = true;
                    int n = maxProgress = level.getBlockState(pos.below()).is(Blocks.CAMPFIRE) ? 50 : 25;
                    if (this.alembicProgress >= maxProgress) {
                        ItemStack itemResult = alembic.getItem(0);
                        alembic.clearContent();
                        chamberBelow.setItem(0, DISTILATION_MAP.get(itemResult.getItem()).getDefaultInstance());
                        this.alembicProgress = 0;
                        AbyssTechUtility.sendSimpleEffects(level, pos, 8, 1.2, ParticleTypes.BUBBLE, AbyssTechSounds.DISTILLED.get());
                    }
                }
                if (!validProgress && this.alembicProgress > 0) {
                    this.alembicProgress = 0;
                }
            }
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            if (this.currentTick >= 60) {
                this.currentTick = 0;
                BlockPos[] descendDirection = new BlockPos[]{pos.offset(-1, -1, 0), pos.offset(1, -1, 0), pos.offset(0, -1, -1), pos.offset(0, -1, 1)};
                Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
                boolean validSetup = false;
                for (int i = 0; i < directions.length; ++i) {
                    if (state.getValue((Property)Alembic.FACING) != directions[i] || !level.getBlockState(descendDirection[i]).is(AbyssTechBlocks.MIXER_CHAMBER)) continue;
                    this.chamberInPlace(level, pos, descendDirection[i]);
                    validSetup = true;
                    break;
                }
                if (!validSetup && this.alembicProgress > 0) {
                    this.alembicProgress = 0;
                }
            }
            ++this.currentTick;
        }
    }
}

