/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.SingleItemContainer;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import net.quasar.abysstech.util.special_recipe.AbyssTechRecipes;
import net.quasar.abysstech.util.special_recipe.AmalgamatorRecipe;
import org.jetbrains.annotations.Nullable;

public class AmalgamatorBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 20;
    private int tickCounter = this.random.nextInt(0, 19);
    private int renderTimer = 0;

    public AmalgamatorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.AMALGAMATOR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("amalgamator.render_timer", this.renderTimer);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.renderTimer = tag.getInt("amalgamator.render_timer");
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public int getRenderTimer() {
        return this.renderTimer;
    }

    public float getRenderCubeSize(boolean outer) {
        if (outer) {
            return (this.renderTimer <= 16 ? 0.02f : 0.01f) * (float)this.renderTimer;
        }
        return 0.02f * (this.renderTimer <= 16 ? (float)this.renderTimer : 32.0f - (float)this.renderTimer * 1.2f);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.renderTimer > 0) {
                ++this.renderTimer;
                if (this.renderTimer > 32) {
                    this.renderTimer = 0;
                }
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            if (this.tickCounter >= 20) {
                BlockEntity blockEntity;
                this.tickCounter = 0;
                if (!level.getBlockState(pPos.above(1)).isAir() && level.getBlockState(pPos.north(1)).is(AbyssTechBlocks.TEAR_VAT) && level.getBlockState(pPos.south(1)).is(AbyssTechBlocks.TEAR_VAT) && level.getBlockState(pPos.east(1)).is(AbyssTechBlocks.TEAR_VAT) && level.getBlockState(pPos.west(1)).is(AbyssTechBlocks.TEAR_VAT) && (blockEntity = level.getBlockEntity(pPos.north(1))) instanceof SingleItemContainerBlockEntity) {
                    SingleItemContainerBlockEntity vatOne = (SingleItemContainerBlockEntity)blockEntity;
                    blockEntity = level.getBlockEntity(pPos.east(1));
                    if (blockEntity instanceof SingleItemContainerBlockEntity) {
                        SingleItemContainerBlockEntity vatTwo = (SingleItemContainerBlockEntity)blockEntity;
                        blockEntity = level.getBlockEntity(pPos.south(1));
                        if (blockEntity instanceof SingleItemContainerBlockEntity) {
                            SingleItemContainerBlockEntity vatThree = (SingleItemContainerBlockEntity)blockEntity;
                            blockEntity = level.getBlockEntity(pPos.west(1));
                            if (blockEntity instanceof SingleItemContainerBlockEntity) {
                                int searchRadius;
                                SingleItemContainerBlockEntity vatFour = (SingleItemContainerBlockEntity)blockEntity;
                                Block catalistBlock = level.getBlockState(pPos.above(1)).getBlock();
                                Item[] tears = new Item[]{vatOne.getItem(0).getItem(), vatTwo.getItem(0).getItem(), vatThree.getItem(0).getItem(), vatFour.getItem(0).getItem()};
                                BlockState result = this.amalgamateRec(tears, catalistBlock);
                                if (result != null && this.searchTakeEssence(level, pPos, searchRadius = AbyssTechUtility.embraceTuneDetect(level, pPos, 2, false, 6, 9, 9), 20, 10)) {
                                    for (Direction direction : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
                                        BlockEntity blockEntity2 = level.getBlockEntity(pPos.relative(direction, 1));
                                        if (!(blockEntity2 instanceof SingleItemContainerBlockEntity)) continue;
                                        SingleItemContainerBlockEntity singleItemContainerBe = (SingleItemContainerBlockEntity)blockEntity2;
                                        singleItemContainerBe.clearContent();
                                        singleItemContainerBe.setItem(0, AbyssTechBlocks.FADED_TEAR_BLOCK.toStack());
                                        level.setBlockAndUpdate(pPos.relative(direction, 1), (BlockState)level.getBlockState(pPos.relative(direction, 1)).setValue((Property)SingleItemContainer.hasItem, (Comparable)Boolean.valueOf(false)));
                                    }
                                    ++this.renderTimer;
                                    level.setBlockAndUpdate(pPos.above(1), result);
                                    this.spawnResidue(level, pPos, result);
                                    level.playSound(null, pPos, AbyssTechSounds.AMALGAMATE.get(), SoundSource.BLOCKS);
                                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)((float)pPos.getX() + 1.5f), (double)((float)pPos.getY() + 1.2f), (double)((float)pPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)((float)pPos.getX() - 0.5f), (double)((float)pPos.getY() + 1.2f), (double)((float)pPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)((float)pPos.getX() + 0.5f), (double)((float)pPos.getY() + 1.2f), (double)((float)pPos.getZ() + 1.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)((float)pPos.getX() + 0.5f), (double)((float)pPos.getY() + 1.2f), (double)((float)pPos.getZ() - 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private BlockState amalgamateRec(Item[] ingredients, Block ingrediantBlock) {
        List<AmalgamatorRecipe> amalgRecList = AbyssTechRecipes.getAllRecipesOfType(AmalgamatorRecipe.class);
        for (AmalgamatorRecipe amalgamatorRecipe : amalgRecList) {
            if (amalgamatorRecipe.getBlockInput() != ingrediantBlock) continue;
            ArrayList<Item> toIterate = new ArrayList<Item>(Arrays.asList(amalgamatorRecipe.getInput()));
            int matches = 0;
            for (int i = 0; i < ingredients.length; ++i) {
                for (int m = 0; m < toIterate.size(); ++m) {
                    if (!ingredients[i].getDefaultInstance().is((Item)toIterate.get(m))) continue;
                    toIterate.remove(m);
                    ++matches;
                    break;
                }
                if (matches < 4) continue;
                return amalgamatorRecipe.getOutput();
            }
        }
        return null;
    }

    private void spawnResidue(Level level, BlockPos pos, BlockState resultingBlock) {
        Item toSpawn;
        Item item = resultingBlock.is((Block)AbyssTechBlocks.ROOTING_ORE.get()) ? (Item)AbyssTechItems.FLOURISHING_RESIDUE.get() : (resultingBlock.is((Block)AbyssTechBlocks.ROTTING_ORE.get()) ? (Item)AbyssTechItems.SANGUINE_RESIDUE.get() : (resultingBlock.is((Block)AbyssTechBlocks.BOUNDARY_ORE.get()) ? (this.random.nextBoolean() ? (Item)AbyssTechItems.FLOURISHING_RESIDUE.get() : (Item)AbyssTechItems.SANGUINE_RESIDUE.get()) : (toSpawn = null)));
        if (toSpawn != null) {
            AbyssTechUtility.ItemSimpleSpawn(level, pos.above(2), toSpawn);
        }
    }
}

