/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.util.AbyssTechUtility;

public class AquaticAcclimatorBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 200;
    private int tickCounter = this.random.nextInt(0, 199);

    public AquaticAcclimatorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.AQUATIC_ACCLIMATOR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter > 200) {
                this.tickCounter = 0;
                int searchRadius = 5;
                double mobSearchRadius = AbyssTechUtility.embraceTuneDetect(level, pPos, 1, false, 8, 14, 14);
                List playerToEffect = level.getEntitiesOfClass(Player.class, new AABB((double)pPos.getX() - mobSearchRadius, (double)pPos.getY() - mobSearchRadius, (double)pPos.getZ() - mobSearchRadius, (double)pPos.getX() + mobSearchRadius, (double)pPos.getY() + mobSearchRadius, (double)pPos.getZ() + mobSearchRadius));
                if (!playerToEffect.isEmpty() && this.searchTakeEssence(level, pPos, searchRadius, 2)) {
                    boolean tunedByVigor = level.getBlockState(pPos.above(1)).getBlock() == AbyssTechBlocks.TUNING_CRYSTAL_VIGOR.get();
                    for (Player player : playerToEffect) {
                        player.setAirSupply(300);
                        if (!tunedByVigor) continue;
                        player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 220, 0));
                    }
                }
            }
        }
    }
}

