/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.WoodenFlesh;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.WoodenFleshBlockEntity;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class ArborealMawBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 1200;
    private int currentTickRate = 1200;
    private int tickCounter = this.random.nextInt(0, 1199);

    public ArborealMawBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ARBOREAL_MAW_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter > this.currentTickRate) {
                this.tickCounter = 0;
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pPos, 1, true, 1200, 600, 300);
                int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pPos, 1, false, 6, 9, 9);
                for (int i = 0; i < 4; ++i) {
                    int offX = 0;
                    int offY = 0;
                    int offZ = 0;
                    switch (i) {
                        case 0: {
                            offX = 1;
                            break;
                        }
                        case 1: {
                            offX = -1;
                            break;
                        }
                        case 2: {
                            offZ = 1;
                            break;
                        }
                        case 3: {
                            offZ = -1;
                        }
                    }
                    BlockPos tarPos = pPos.offset(offX, offY, offZ);
                    if (!level.getBlockState(tarPos).is(BlockTags.LOGS) || !this.searchTakeEssence(level, pPos, searchRadius, 4, 3)) continue;
                    BlockState logState = level.getBlockState(tarPos);
                    level.setBlockAndUpdate(tarPos, (BlockState)((Block)AbyssTechBlocks.WOODEN_FLESH.get()).defaultBlockState().setValue((Property)WoodenFlesh.spreadSearch, (Comparable)Integer.valueOf(30)));
                    BlockEntity blockEntity = level.getBlockEntity(tarPos);
                    if (blockEntity instanceof WoodenFleshBlockEntity) {
                        WoodenFleshBlockEntity woodenFlesh = (WoodenFleshBlockEntity)blockEntity;
                        woodenFlesh.setLogState(logState);
                    }
                    level.playSound(null, pPos, AbyssTechSounds.HOLLOW_LOG.get(), SoundSource.BLOCKS);
                }
            }
        }
    }
}

