/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssalEngine;
import net.quasar.abysstech.block.custom.Breaker;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;

public class BreakerBlockEntity
extends AbstractEssenceMachine {
    private int minePosX;
    private int minePosY;
    private int minePosZ;
    private static final Map<Block, Block> TRANSMUTING_MAP = Map.of(Blocks.COBBLESTONE, Blocks.GRAVEL, Blocks.GRAVEL, Blocks.SAND, Blocks.BLUE_ICE, Blocks.PACKED_ICE, Blocks.PACKED_ICE, Blocks.ICE, Blocks.MAGMA_BLOCK, Blocks.OBSIDIAN, Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN, Blocks.GRASS_BLOCK, Blocks.DIRT);
    private final Random random = new Random();
    private final int tickRate = 80;
    private int currentTickRate = 80;
    private int tickCounter = this.random.nextInt(0, 79);
    private final Block MirrorBlock = (Block)AbyssTechBlocks.REFLECTOR_LIVELY.get();
    private final Block MirrorBlockTwo = (Block)AbyssTechBlocks.REFLECTOR_VIBRANT.get();

    public BreakerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.BREAKER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.minePosX = pTag.getInt("mine_pos_x");
        this.minePosY = pTag.getInt("mine_pos_y");
        this.minePosZ = pTag.getInt("mine_pos_z");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("mine_pos_x", this.minePosX);
        pTag.putInt("mine_pos_y", this.minePosY);
        pTag.putInt("mine_pos_z", this.minePosZ);
        super.saveAdditional(pTag, pRegistries);
    }

    private void iterateQuarryPos(BlockPos pos, BlockState state) {
        ++this.minePosX;
        if (this.minePosX > pos.getX() + (Integer)state.getValue((Property)Breaker.quarrySize)) {
            this.minePosX = pos.getX() - (Integer)state.getValue((Property)Breaker.quarrySize);
            ++this.minePosZ;
            if (this.minePosZ > pos.getZ() + (Integer)state.getValue((Property)Breaker.quarrySize)) {
                this.minePosZ = pos.getZ() - (Integer)state.getValue((Property)Breaker.quarrySize);
                --this.minePosY;
            }
        }
    }

    private boolean multiBlockQuarryCheck(Level level, BlockPos pos) {
        boolean isFormed = false;
        if (level.getBlockState(pos.above(1)).is(AbyssTechBlocks.ABYSSAL_ENGINE) && level.getBlockState(pos.above(2)).is(AbyssTechBlocks.ETHEREAL_EMITTER) && ((Boolean)level.getBlockState(pos.above(1)).getValue((Property)AbyssalEngine.hasTube)).booleanValue() && level.getBlockState(pos.north(1)).is(this.MirrorBlock) && level.getBlockState(pos.south(1)).is(this.MirrorBlock) && level.getBlockState(pos.east(1)).is(this.MirrorBlock) && level.getBlockState(pos.south(1)).is(this.MirrorBlock)) {
            isFormed = true;
        }
        return isFormed;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                int searchRadius;
                this.tickCounter = 0;
                boolean quarryFormed = this.multiBlockQuarryCheck(level, pos);
                if (quarryFormed) {
                    this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, -1, true, 20, 10, 5);
                    searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, -1, true, 3, 6, 9);
                } else {
                    this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 80, 40, 20);
                    searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, 1, true, 6, 9, 12);
                }
                BlockState[][] checkMirrorAndToChange = new BlockState[][]{{level.getBlockState(pos.above(2)), level.getBlockState(pos.above(1))}, {level.getBlockState(pos.below(2)), level.getBlockState(pos.below(1))}, {level.getBlockState(pos.south(2)), level.getBlockState(pos.south(1))}, {level.getBlockState(pos.north(2)), level.getBlockState(pos.north(1))}, {level.getBlockState(pos.east(2)), level.getBlockState(pos.east(1))}, {level.getBlockState(pos.west(2)), level.getBlockState(pos.west(1))}};
                BlockPos[] targetBlockPos = new BlockPos[]{pos.offset(0, 1, 0), pos.offset(0, -1, 0), pos.offset(0, 0, 1), pos.offset(0, 0, -1), pos.offset(1, 0, 0), pos.offset(-1, 0, 0)};
                if (quarryFormed && ((Boolean)state.getValue((Property)Breaker.quarryActive)).booleanValue()) {
                    if (!((Boolean)state.getValue((Property)Breaker.firstQuarryCheck)).booleanValue()) {
                        this.minePosX = pos.getX() - (Integer)state.getValue((Property)Breaker.quarrySize);
                        this.minePosY = pos.getY() - 1;
                        this.minePosZ = pos.getZ() - (Integer)state.getValue((Property)Breaker.quarrySize);
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Breaker.firstQuarryCheck, (Comparable)Boolean.valueOf(true)));
                    }
                    if (this.searchTakeEssence(level, pos, searchRadius, 1, 1)) {
                        BlockPos mineBlockPos = new BlockPos(this.minePosX, this.minePosY, this.minePosZ);
                        if (!level.getBlockState(mineBlockPos).isAir() && !level.getBlockState(mineBlockPos).is(AbyssTechTags.Blocks.QUARRY_CANT_MINE) && mineBlockPos.getY() > -64) {
                            ServerLevel serverLevel = ((ServerLevel)level).getLevel();
                            LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)mineBlockPos)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(mineBlockPos)).withParameter(LootContextParams.TOOL, (Object)Items.NETHERITE_PICKAXE.getDefaultInstance());
                            List drops = level.getBlockState(mineBlockPos).getDrops(lootBuilder);
                            Item toDrop = drops.isEmpty() ? null : ((ItemStack)drops.getFirst()).getItem();
                            AbyssTechUtility.drawPathToTarget(level, pos, mineBlockPos, 0.02f, AbyssTechParticles.LIVELY_BEAM_PARTICLES.get());
                            level.destroyBlock(mineBlockPos, false);
                            if (toDrop != null) {
                                AbyssTechUtility.ItemSimpleSpawn(level, pos.above(4), toDrop);
                            }
                        }
                        if (mineBlockPos.getY() == -64) {
                            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)Breaker.quarryActive, (Comparable)Boolean.valueOf(false))).setValue((Property)Breaker.firstQuarryCheck, (Comparable)Boolean.valueOf(false)));
                        }
                        this.iterateQuarryPos(pos, state);
                    }
                } else {
                    for (int i = 0; i < checkMirrorAndToChange.length; ++i) {
                        if (!checkMirrorAndToChange[i][0].is(this.MirrorBlock) && !checkMirrorAndToChange[i][0].is(this.MirrorBlockTwo) || (!checkMirrorAndToChange[i][1].is(AbyssTechTags.Blocks.BREAKER_BREAKABLE) || !checkMirrorAndToChange[i][0].is(this.MirrorBlock)) && (!checkMirrorAndToChange[i][1].is(AbyssTechTags.Blocks.BREAKER_TRANSMUTABLE) || !checkMirrorAndToChange[i][0].is(this.MirrorBlockTwo)) || !this.searchTakeEssence(level, pos, searchRadius, 1, 1)) continue;
                        if (checkMirrorAndToChange[i][1].is(AbyssTechTags.Blocks.BREAKER_BREAKABLE) && checkMirrorAndToChange[i][0].is(this.MirrorBlock)) {
                            level.destroyBlock(targetBlockPos[i], true);
                            if (((Boolean)level.getBlockState(pos).getValue((Property)Breaker.upgraded)).booleanValue() && this.random.nextInt(20) < 2) {
                                ItemStack extraDrop = this.random.nextBoolean() ? AbyssTechItems.RAW_THRIVING_MUSH.toStack() : AbyssTechItems.RAW_VISCERAL_HEAP.toStack();
                                AbyssTechUtility.ItemSimpleSpawn(level, targetBlockPos[i], extraDrop.getItem());
                            }
                            level.playSound(null, pos, AbyssTechSounds.MAGIC_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            continue;
                        }
                        if (!checkMirrorAndToChange[i][1].is(AbyssTechTags.Blocks.BREAKER_TRANSMUTABLE) || !checkMirrorAndToChange[i][0].is(this.MirrorBlockTwo)) continue;
                        level.setBlockAndUpdate(targetBlockPos[i], TRANSMUTING_MAP.get(checkMirrorAndToChange[i][1].getBlock()).defaultBlockState());
                        level.playSound(null, pos, AbyssTechSounds.MAGIC_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

