/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.CreativeVat;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import org.jetbrains.annotations.Nullable;

public class CreativeVatBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int currentTick = 0;

    public CreativeVatBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.CREATIVE_VAT_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.set(slot, (Object)ItemStack.EMPTY);
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return false;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty() && slot != 1;
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            if (this.currentTick >= 5) {
                this.currentTick = 0;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof CreativeVatBlockEntity) {
                    CreativeVatBlockEntity creativeVatBlockEntity = (CreativeVatBlockEntity)blockEntity;
                    if (!creativeVatBlockEntity.getItem(1).isEmpty()) {
                        creativeVatBlockEntity.setItem(0, creativeVatBlockEntity.getItem(1));
                    }
                    if (creativeVatBlockEntity.getItem(1).isEmpty()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CreativeVat.hasItem, (Comparable)Boolean.valueOf(false)));
                    } else {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CreativeVat.hasItem, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
            ++this.currentTick;
        }
    }
}

