/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.DisplacedVoid;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class DisplacedVoidBlockEntity
extends BlockEntity {
    private float cubeBobX = 0.0f;
    private float cubeBobY = 0.0f;
    private float cubeBobZ = 0.0f;
    private boolean marginX = true;
    private boolean marginY = true;
    private boolean marginZ = true;
    private final Random random = new Random();
    private final int tickRate = 10;
    private int currentTickRate = 10;
    private int tickCounter = this.random.nextInt(0, 9);

    public DisplacedVoidBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.DISPLACED_VOID_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public float bobRenderedCubeX(float bobSpeed) {
        float slow = this.cubeBobX < 0.05f || this.cubeBobX > 0.1f ? (this.cubeBobX < 0.03f || this.cubeBobX > 0.12f ? (this.cubeBobX < 0.01f || this.cubeBobX > 0.14f ? bobSpeed : bobSpeed * 2.0f) : bobSpeed * 3.0f) : bobSpeed * 4.0f;
        this.cubeBobX = this.marginX ? this.cubeBobX + slow : this.cubeBobX - slow;
        this.marginX = !(this.cubeBobX > 0.15f) && (this.cubeBobX < 0.0f || this.marginX);
        return this.cubeBobX - 0.075f;
    }

    public float bobRenderedCubeY(float bobSpeed) {
        float slow = this.cubeBobY < 0.05f || this.cubeBobY > 0.1f ? (this.cubeBobY < 0.03f || this.cubeBobY > 0.12f ? (this.cubeBobY < 0.01f || this.cubeBobY > 0.14f ? bobSpeed : bobSpeed * 2.0f) : bobSpeed * 3.0f) : bobSpeed * 4.0f;
        this.cubeBobY = this.marginY ? this.cubeBobY + slow : this.cubeBobY - slow;
        this.marginY = !(this.cubeBobY > 0.15f) && (this.cubeBobY < 0.0f || this.marginY);
        return this.cubeBobY - 0.075f;
    }

    public float bobRenderedCubeZ(float bobSpeed) {
        float slow = this.cubeBobZ < 0.05f || this.cubeBobZ > 0.1f ? (this.cubeBobZ < 0.03f || this.cubeBobZ > 0.12f ? (this.cubeBobZ < 0.01f || this.cubeBobZ > 0.14f ? bobSpeed : bobSpeed * 2.0f) : bobSpeed * 3.0f) : bobSpeed * 4.0f;
        this.cubeBobZ = this.marginZ ? this.cubeBobZ + slow : this.cubeBobZ - slow;
        this.marginZ = !(this.cubeBobZ > 0.15f) && (this.cubeBobZ < 0.0f || this.marginZ);
        return this.cubeBobZ - 0.075f;
    }

    public void tick(Level level, BlockPos pos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                int instabilityAmount;
                this.tickCounter = 0;
                level.playSound(null, pos, AbyssTechSounds.VOID_HUM.get(), SoundSource.BLOCKS);
                int searchRadius = 20;
                if (this.random.nextInt(10) < 1) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.LOOMING_MAN.get(), (double)((float)pos.getX() + this.random.nextFloat(-searchRadius, searchRadius)), (double)((float)pos.getY() - 4.0f), (double)((float)pos.getZ() + this.random.nextFloat(-searchRadius, searchRadius)), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.random.nextInt(30) < 1) {
                    level.playSound(null, pos, this.random.nextBoolean() ? AbyssTechSounds.VOID_HUM_ONE.get() : AbyssTechSounds.VOID_HUM_TWO.get(), SoundSource.BLOCKS);
                }
                int entitySearchRadius = 5;
                List<LivingEntity> e = AbyssTechUtility.getEntitiesInArea(level, pos, LivingEntity.class, entitySearchRadius);
                for (LivingEntity entity : e) {
                    if (this.invalidEntity(entity)) continue;
                    entity.hurt(entity.damageSources().fellOutOfWorld(), 2.0f);
                    ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.FORCE_PARTICLES.get(), entity.getX(), entity.getY() + (double)1.3f, entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if ((Integer)pState.getValue((Property)DisplacedVoid.unstable) < 50 && (instabilityAmount = AbyssTechUtility.getThresholdIntegrity(level, pos)) > 10) {
                    AbyssTechUtility.setThresholdIntegrity(level, pos, 10, false);
                    level.setBlockAndUpdate(pos, (BlockState)pState.setValue((Property)DisplacedVoid.unstable, (Comparable)Integer.valueOf((Integer)pState.getValue((Property)DisplacedVoid.unstable) + 1)));
                }
            }
        }
    }

    private boolean invalidEntity(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.isCreative();
        }
        return false;
    }
}

