/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.Effigy;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.particle.AbyssTechParticles;
import org.jetbrains.annotations.Nullable;

public class EffigyBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 40;
    private int tickCounter = this.random.nextInt(0, 39);
    private int renderType = 0;
    private int renderTick = 0;
    private final int renderTickMax = 80;
    private float itemRotation = 0.0f;

    public EffigyBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.EFFIGY_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("effigy.render_type", this.renderType);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.renderType = tag.getInt("effigy.render_type");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            this.renderTicking(state);
            if (this.tickCounter > 40) {
                this.tickCounter = 0;
                Block[] effigyType = new Block[]{(Block)AbyssTechBlocks.EFFIGY_SHIVERING.get(), (Block)AbyssTechBlocks.EFFIGY_WRATHFUL.get(), (Block)AbyssTechBlocks.EFFIGY_LOVING.get(), (Block)AbyssTechBlocks.EFFIGY_HAUNTED.get(), (Block)AbyssTechBlocks.EFFIGY_TIRED.get(), (Block)AbyssTechBlocks.EFFIGY_INSPIRED.get(), (Block)AbyssTechBlocks.EFFIGY_DREAMING.get(), (Block)AbyssTechBlocks.EFFIGY_DIVIDED.get()};
                SimpleParticleType[] toSpawnArray = new SimpleParticleType[]{AbyssTechParticles.SHIVERING_PARTICLES.get(), AbyssTechParticles.WRATHFUL_PARTICLES.get(), AbyssTechParticles.LOVING_PARTICLES.get(), AbyssTechParticles.HAUNTED_PARTICLES.get(), AbyssTechParticles.TIRED_PARTICLES.get(), AbyssTechParticles.INSPIRED_PARTICLES.get(), AbyssTechParticles.DREAMING_PARTICLES.get(), AbyssTechParticles.DIVIDED_PARTICLES.get()};
                for (int i = 0; i < effigyType.length; ++i) {
                    if (!state.is(effigyType[i])) continue;
                    ((ServerLevel)level).sendParticles((ParticleOptions)toSpawnArray[i], (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.85f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    break;
                }
            }
        }
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void setRenderType(int type) {
        this.renderType = type;
    }

    public void sendUpdate() {
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    private void resetRendering() {
        this.renderType = 0;
        this.renderTick = 0;
        this.sendUpdate();
    }

    private void renderTicking(BlockState state) {
        if (this.renderType > 0) {
            if (!((Boolean)state.getValue((Property)Effigy.Locked)).booleanValue()) {
                ++this.renderTick;
            }
            if (this.renderTick > this.renderTickMax) {
                this.resetRendering();
            }
        }
    }

    public void setRenderTick(int tick) {
        this.renderTick = tick;
    }

    public int getRenderTickMax() {
        return this.renderTickMax;
    }

    public float rotateRenderedItem() {
        this.itemRotation -= 2.0f;
        if (this.itemRotation > 360.0f) {
            this.itemRotation = 0.0f;
        }
        return this.itemRotation;
    }
}

