/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.util.AbyssTechUtility;

public class EntityPushPullBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 50;
    private final int tickRateTwo = 5;
    private int tickCounter = this.random.nextInt(0, 49);
    private boolean isFedEssence = false;

    public EntityPushPullBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ENTITY_PUSH_PULL_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter > 50) {
                this.tickCounter = 0;
                int searchRadius = 5;
                this.isFedEssence = this.searchTakeEssence(level, pos, searchRadius, 2);
            }
            if (this.tickCounter % 5 == 0 && this.isFedEssence) {
                if (state.is(AbyssTechBlocks.HUNGRY_LAMP)) {
                    this.hungry(level, pos, 6);
                } else if (state.is(AbyssTechBlocks.RADIANT_LAMP)) {
                    this.radiant(level, pos, 6);
                }
            }
        }
    }

    private void hungry(Level level, BlockPos pos, int radius) {
        SingleItemContainerBlockEntity pedestal;
        BlockEntity blockEntity;
        List<ItemEntity> itemToMove = AbyssTechUtility.getEntitiesInArea(level, pos, ItemEntity.class, radius);
        ItemStack filteredItem = null;
        if (level.getBlockState(pos.above(1)).is(AbyssTechBlocks.MORT_PEDESTAL) && (blockEntity = level.getBlockEntity(pos.above(1))) instanceof SingleItemContainerBlockEntity && !(pedestal = (SingleItemContainerBlockEntity)blockEntity).isEmpty()) {
            filteredItem = pedestal.getItem(0);
        }
        for (ItemEntity itemEntity : itemToMove) {
            if (filteredItem != null) {
                if (!filteredItem.is(itemEntity.getItem().getItem())) continue;
                this.moveItem(level, pos, itemEntity);
                continue;
            }
            this.moveItem(level, pos, itemEntity);
        }
    }

    private void moveItem(Level level, BlockPos pos, ItemEntity itemEntity) {
        if (AbyssTechUtility.vigorTuneDetect(level, pos, -1)) {
            itemEntity.teleportTo((double)pos.getX(), (double)(pos.getY() - 2), (double)pos.getZ());
        } else {
            double moveStrength = this.getMoveStrength(level, pos, 0.05);
            double moveX = -Math.signum(itemEntity.getX() - (double)pos.getX() - 0.5) * moveStrength;
            double moveZ = -Math.signum(itemEntity.getZ() - (double)pos.getZ() - 0.5) * moveStrength;
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(moveX, 0.0, moveZ));
        }
    }

    private void radiant(Level level, BlockPos pos, int radius) {
        List<Monster> mobToMove = AbyssTechUtility.getEntitiesInArea(level, pos, Monster.class, radius);
        for (Monster monster : mobToMove) {
            double moveStrength = this.getMoveStrength(level, pos, 0.1);
            double moveX = Math.signum(monster.getX() - (double)pos.getX()) * moveStrength;
            double moveZ = Math.signum(monster.getZ() - (double)pos.getZ()) * moveStrength;
            monster.setDeltaMovement(monster.getDeltaMovement().add(moveX, 0.0, moveZ));
        }
    }

    private double getMoveStrength(Level level, BlockPos pos, double baseStrength) {
        return switch (AbyssTechUtility.vigorTuneDetect(level, pos, 1, true)) {
            case 1 -> baseStrength * 2.0;
            case 2 -> baseStrength * 4.0;
            default -> baseStrength;
        };
    }
}

