/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.EntropicForge;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class EntropicForgeBlockEntity
extends AbstractEssenceMachine
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private float rotation = 0.0f;
    private final Random random = new Random();
    private final int tickRate = 80;
    private int currentTickRate = 80;
    private int tickCounter = this.random.nextInt(0, 79);
    private int hasItemUpdateTick = 0;

    public EntropicForgeBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ENTROPIC_FORGE_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.setChanged();
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        if (this.validSegment(this.getBlockState())) {
            return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
        }
        return false;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        if (this.level != null && this.validSegment(this.getBlockState())) {
            Optional optional = this.level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), this.level);
            this.setChanged();
            return !this.getItem(slot).isEmpty() && optional.isEmpty() && !stack.is(Items.COAL);
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public float entropicForgeItemRotation() {
        this.rotation += 0.2f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    private boolean validSegment(BlockState state) {
        return state.getValue((Property)EntropicForge.SEGMENT) == MultiBlockSegment.BOTTOM;
    }

    public void tick(Level level, BlockPos pPos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && this.validSegment(state) && (blockEntity = level.getBlockEntity(pPos)) instanceof EntropicForgeBlockEntity) {
            EntropicForgeBlockEntity entropicForgeBlockEntity = (EntropicForgeBlockEntity)blockEntity;
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.tickCounter = 0;
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pPos, 2, true, 80, 60, 30);
                int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pPos, 2, false, 6, 9, 9);
                if (!entropicForgeBlockEntity.isEmpty()) {
                    boolean foundEssence;
                    ItemStack cookingResult;
                    ItemStack toCook = entropicForgeBlockEntity.getItem(0);
                    Optional optional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(toCook), level);
                    if (entropicForgeBlockEntity.getItem(0).is(Items.COAL)) {
                        boolean foundEssence2 = this.searchTakeEssence(level, pPos, searchRadius, 5, 2);
                        if (foundEssence2) {
                            entropicForgeBlockEntity.setItem(0, AbyssTechItems.ANTHRACITE.toStack());
                            level.setBlockAndUpdate(pPos, (BlockState)level.getBlockState(pPos).setValue((Property)EntropicForge.forgeFired, (Comparable)Boolean.valueOf(true)));
                            level.playSound(null, pPos, AbyssTechSounds.MAGIC_FORGE.get(), SoundSource.BLOCKS);
                        }
                    } else if (optional.isPresent() && !(cookingResult = ((SmeltingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess())).isEmpty() && (foundEssence = this.searchTakeEssence(level, pPos, searchRadius, 3, 1))) {
                        entropicForgeBlockEntity.setItem(0, cookingResult);
                        level.setBlockAndUpdate(pPos, (BlockState)level.getBlockState(pPos).setValue((Property)EntropicForge.forgeFired, (Comparable)Boolean.valueOf(true)));
                        level.playSound(null, pPos, AbyssTechSounds.MAGIC_FORGE.get(), SoundSource.BLOCKS);
                    }
                } else {
                    level.setBlockAndUpdate(pPos, (BlockState)level.getBlockState(pPos).setValue((Property)EntropicForge.forgeFired, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (this.hasItemUpdateTick >= 10) {
                level.setBlockAndUpdate(pPos, (BlockState)state.setValue((Property)EntropicForge.hasItem, (Comparable)Boolean.valueOf(!entropicForgeBlockEntity.isEmpty())));
                this.hasItemUpdateTick = 0;
            }
            ++this.hasItemUpdateTick;
        }
    }
}

