/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.EphemeralPot;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class EphemeralPotBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private float itemRotation = 0.0f;
    private float itemBob = 0.0f;
    private boolean itemBobRising = true;
    private int upgrades = 1;
    private float[] targetLoc = new float[]{0.0f, 0.0f, 0.0f};
    private int hasItemUpdateTick = 0;
    private final int tickRate = 10;

    public EphemeralPotBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.EPHEMERAL_POT_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public float rotateRenderedItem() {
        this.itemRotation += 0.5f;
        if (this.itemRotation > 360.0f) {
            this.itemRotation = 0.0f;
        }
        return this.itemRotation;
    }

    public float bobRenderedItem() {
        float slow = this.itemBob < 0.05f || this.itemBob > 0.1f ? (this.itemBob < 0.03f || this.itemBob > 0.12f ? (this.itemBob < 0.01f || this.itemBob > 0.14f ? 0.001f : 0.002f) : 0.003f) : 0.004f;
        this.itemBob = this.itemBobRising ? this.itemBob + slow : this.itemBob - slow;
        this.itemBobRising = !(this.itemBob > 0.15f) && (this.itemBob < 0.0f || this.itemBobRising);
        return this.itemBob;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return this.isItemCentered(this.getBlockPos(), 0.12f) && !this.getItem(slot).isEmpty();
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putFloat("ephemeral_pot.tar_x", this.targetLoc[0]);
        tag.putFloat("ephemeral_pot.tar_y", this.targetLoc[1]);
        tag.putFloat("ephemeral_pot.tar_z", this.targetLoc[2]);
        tag.putInt("ephemeral_pot.upgrades", this.upgrades);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.targetLoc[0] = tag.getFloat("ephemeral_pot.tar_x");
        this.targetLoc[1] = tag.getFloat("ephemeral_pot.tar_y");
        this.targetLoc[2] = tag.getFloat("ephemeral_pot.tar_z");
        this.upgrades = tag.getInt("ephemeral_pot.upgrades");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof EphemeralPotBlockEntity) {
            EphemeralPotBlockEntity ephemeralPotBlockEntity = (EphemeralPotBlockEntity)blockEntity;
            this.moveItemToCenter(level, pos, state, ephemeralPotBlockEntity, this.upgrades);
            if (this.hasItemUpdateTick >= 10) {
                this.hasItemUpdateTick = 0;
                this.checkForUpgrade(level, pos);
                AbyssTechUtility.updateItemRenderBooleanState(level, state, pos, EphemeralPot.hasItem, ephemeralPotBlockEntity);
                this.pickupItem(level, pos, 10, ephemeralPotBlockEntity);
            }
            ++this.hasItemUpdateTick;
        }
    }

    private void checkForUpgrade(Level level, BlockPos pos) {
        this.upgrades = AbyssTechUtility.flowTuneDetect(level, pos, level.getBlockState(pos.above(1)).is(AbyssTechBlocks.MORT_PEDESTAL) ? 2 : 1, true, 1, 2, 3);
    }

    private boolean isItemCentered(BlockPos pos, float disposition) {
        return this.targetLoc[0] <= (float)pos.getX() + 0.5f + disposition && this.targetLoc[0] >= (float)pos.getX() + 0.5f - disposition && this.targetLoc[1] <= (float)pos.getY() + 0.5f + disposition && this.targetLoc[1] >= (float)pos.getY() + 0.5f - disposition && this.targetLoc[2] <= (float)pos.getZ() + 0.5f + disposition && this.targetLoc[2] >= (float)pos.getZ() + 0.5f - disposition;
    }

    private void moveItemToCenter(Level level, BlockPos pos, BlockState state, EphemeralPotBlockEntity ephemeralPotBlockEntity, float speedMultiplayer) {
        if (!ephemeralPotBlockEntity.isEmpty() && !this.isItemCentered(pos, 0.1f)) {
            if (this.targetLoc[0] > (float)pos.getX() + 0.5f + 0.1f) {
                this.targetLoc[0] = this.targetLoc[0] - 0.01f * speedMultiplayer;
            } else if (this.targetLoc[0] < (float)pos.getX() + 0.5f - 0.01f * speedMultiplayer) {
                this.targetLoc[0] = this.targetLoc[0] + 0.01f;
            }
            if (this.targetLoc[1] > (float)pos.getY() + 0.5f + 0.1f) {
                this.targetLoc[1] = this.targetLoc[1] - 0.01f * speedMultiplayer;
            } else if (this.targetLoc[1] < (float)pos.getY() + 0.5f - 0.01f * speedMultiplayer) {
                this.targetLoc[1] = this.targetLoc[1] + 0.01f;
            }
            if (this.targetLoc[2] > (float)pos.getZ() + 0.5f + 0.1f) {
                this.targetLoc[2] = this.targetLoc[2] - 0.01f * speedMultiplayer;
            } else if (this.targetLoc[2] < (float)pos.getZ() + 0.5f - 0.01f * speedMultiplayer) {
                this.targetLoc[2] = this.targetLoc[2] + 0.01f;
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public float[] getGrabbedItemLoc() {
        return this.targetLoc;
    }

    public void setGrabbedItemLoc(float x, float y, float z) {
        this.targetLoc = new float[]{x, y, z};
    }

    private void pickupItem(Level level, BlockPos pos, int range, EphemeralPotBlockEntity ephemeralPotBlockEntity) {
        List<ItemEntity> items;
        if (ephemeralPotBlockEntity.isEmpty() && !(items = AbyssTechUtility.getEntitiesInArea(level, pos, ItemEntity.class, range)).isEmpty()) {
            boolean isFiltered = false;
            BlockEntity blockEntity = level.getBlockEntity(pos.above(1));
            if (blockEntity instanceof SingleItemContainerBlockEntity) {
                SingleItemContainerBlockEntity pedestal = (SingleItemContainerBlockEntity)blockEntity;
                if (level.getBlockState(pos.above(1)).is(AbyssTechBlocks.MORT_PEDESTAL) && !pedestal.isEmpty()) {
                    isFiltered = true;
                    for (ItemEntity item : items) {
                        if (!item.getItem().is(pedestal.getItem(0).getItem())) continue;
                        ephemeralPotBlockEntity.setItem(0, item.getItem());
                        this.targetLoc = new float[]{(float)item.getX(), (float)item.getY(), (float)item.getZ()};
                        item.getItem().shrink(1);
                        break;
                    }
                }
            }
            if (!isFiltered) {
                ephemeralPotBlockEntity.setItem(0, items.getFirst().getItem());
                this.targetLoc = new float[]{(float)items.getFirst().getX(), (float)items.getFirst().getY(), (float)items.getFirst().getZ()};
                items.getFirst().getItem().shrink(1);
            }
        }
    }
}

