/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.EssenceCoil;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class EssenceCoilBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int maxCoilEssence = 20;
    private int coilEssence = 0;
    private int coilIntensity = 1;
    private int beamDist = 0;
    private float beamSize = 0.0f;
    private final int tickRate = 5;
    private int tickCounter = this.random.nextInt(0, 4);
    private int cooldownTick = 0;
    private int maxCooldown = 40;

    public EssenceCoilBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ESSENCE_COIL_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.coilEssence = pTag.getInt("coil_essence_amount");
        this.coilIntensity = pTag.getInt("coil_intensity");
        this.cooldownTick = pTag.getInt("coil_cooldown");
        this.beamDist = pTag.getInt("coil_beam_dist");
        this.beamSize = pTag.getFloat("coil_beam_size");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("coil_essence_amount", this.coilEssence);
        pTag.putInt("coil_intensity", this.coilIntensity);
        pTag.putInt("coil_cooldown", this.cooldownTick);
        pTag.putInt("coil_beam_dist", this.beamDist);
        pTag.putFloat("coil_beam_size", this.beamSize);
        super.saveAdditional(pTag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            this.updateBeamSize(state);
            if (this.tickCounter > 5) {
                this.tickCounter = 0;
                this.collectEssence(level, pos, state);
                if ((Integer)state.getValue((Property)EssenceCoil.fireState) == 1) {
                    if (this.getCoilEssence() == this.getMaxCoilEssence()) {
                        BlockPos tarPos;
                        this.setBeamDist(0);
                        boolean foundValidBlockTarget = false;
                        for (int i = 1; i < 5; ++i) {
                            tarPos = this.getDistancePosByDirection(state, pos, i);
                            BlockEntity blockEntity = level.getBlockEntity(tarPos);
                            if (blockEntity instanceof EssenceCoilBlockEntity) {
                                BlockState tarState;
                                EssenceCoilBlockEntity targetCoil = (EssenceCoilBlockEntity)blockEntity;
                                if (targetCoil.getCoilEssence() != targetCoil.getMaxCoilEssence() || (Integer)(tarState = targetCoil.getBlockState()).getValue((Property)EssenceCoil.fireState) != 0) continue;
                                level.setBlockAndUpdate(tarPos, (BlockState)tarState.setValue((Property)EssenceCoil.fireState, (Comparable)Integer.valueOf(1)));
                                targetCoil.setCoilIntensity(targetCoil.getCoilIntensity() + this.getCoilIntensity());
                                this.setBeamDist(i);
                                level.playSound(null, pos, AbyssTechSounds.COIL_HUM.get(), SoundSource.BLOCKS, 1.0f, Math.min((float)this.getCoilIntensity() * 0.02f + 1.0f, 2.0f));
                                foundValidBlockTarget = true;
                                break;
                            }
                            if (!level.getBlockState(tarPos).is(AbyssTechBlocks.CRYSTAL_GLASS) || this.getCoilIntensity() < 5 || this.getCoilIntensity() > 10) continue;
                            level.setBlockAndUpdate(tarPos, ((Block)AbyssTechBlocks.OVERCHARGED_CUBE.get()).defaultBlockState());
                            this.setBeamDist(i);
                            AbyssTechUtility.setThresholdIntegrity(level, pos, this.getCoilIntensity(), true);
                            level.playSound(null, pos, AbyssTechSounds.COIL_FIRE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            foundValidBlockTarget = true;
                            break;
                        }
                        if (!foundValidBlockTarget) {
                            int fireDist = 5 + this.getCoilIntensity() / 3;
                            int damage = 4 + this.getCoilIntensity() * (this.getCoilIntensity() / 2);
                            for (int t = 1; t < fireDist; ++t) {
                                tarPos = this.getDistancePosByDirection(state, pos, t);
                                List entityToEffect = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)tarPos.getX(), (double)tarPos.getY(), (double)tarPos.getZ(), (double)(tarPos.getX() + 1), (double)(tarPos.getY() + 1), (double)(tarPos.getZ() + 1)));
                                for (LivingEntity livingEntity : entityToEffect) {
                                    livingEntity.hurt(livingEntity.damageSources().magic(), (float)damage);
                                }
                                if (t < fireDist - 1) continue;
                                this.setBeamDist(t);
                            }
                            AbyssTechUtility.setThresholdIntegrity(level, pos, this.getCoilIntensity(), true);
                            level.playSound(null, pos, AbyssTechSounds.COIL_FIRE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EssenceCoil.fireState, (Comparable)Integer.valueOf(2)));
                    this.setCoilEssence(0);
                    this.setCoilIntensity(1);
                }
                this.coolDown(level, pos, state);
            }
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private void coolDown(Level level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)EssenceCoil.fireState) == 2) {
            ++this.cooldownTick;
            if (this.cooldownTick >= this.maxCooldown) {
                this.cooldownTick = 0;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EssenceCoil.fireState, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    private void updateBeamSize(BlockState state) {
        if ((Integer)state.getValue((Property)EssenceCoil.fireState) == 2) {
            this.beamSize += 0.01f;
        } else if (this.beamSize != 0.0f) {
            this.beamSize = 0.0f;
        }
    }

    private void collectEssence(Level level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)EssenceCoil.fireState) == 0 && this.getCoilEssence() < this.getMaxCoilEssence() && this.searchTakeEssence(level, pos, 2, 1)) {
            this.setCoilEssence(this.getCoilEssence() + 1);
        }
    }

    public float getBeamSize() {
        return this.beamSize;
    }

    public int getBeamDist() {
        return this.beamDist;
    }

    public void setBeamDist(int distance) {
        this.beamDist = distance;
    }

    private BlockPos getDistancePosByDirection(BlockState state, BlockPos pos, int distance) {
        return switch ((Direction)state.getValue((Property)EssenceCoil.FACING)) {
            case Direction.NORTH -> pos.offset(0, 0, -distance);
            case Direction.SOUTH -> pos.offset(0, 0, distance);
            case Direction.EAST -> pos.offset(distance, 0, 0);
            case Direction.WEST -> pos.offset(-distance, 0, 0);
            case Direction.UP -> pos.offset(0, distance, 0);
            default -> pos.offset(0, -distance, 0);
        };
    }

    public int getCooldown() {
        return this.cooldownTick;
    }

    public int getCoilEssence() {
        return this.coilEssence;
    }

    public int getMaxCoilEssence() {
        return 20;
    }

    public int getCoilIntensity() {
        return this.coilIntensity;
    }

    public void setCoilEssence(int amount) {
        this.coilEssence = amount;
    }

    public void setCoilIntensity(int amount) {
        this.coilIntensity = amount;
    }
}

