/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.EssenceFunnel;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.util.AbyssTechUtility;

public class EssenceFunnelBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 10;
    private int tickCounter = this.random.nextInt(0, 9);

    public EssenceFunnelBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ESSENCE_FUNNEL_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter > 10) {
                EssenceJarBlockEntity essenceJarBlock;
                int belowEssence;
                BlockEntity essenceJarBlock22;
                this.tickCounter = 0;
                int[] step = new int[]{0, 0, 0};
                int[] tar = new int[]{0, 0, 0};
                switch ((Direction)state.getValue((Property)EssenceFunnel.FACING)) {
                    case NORTH: {
                        step[2] = -1;
                        break;
                    }
                    case SOUTH: {
                        step[2] = 1;
                        break;
                    }
                    case EAST: {
                        step[0] = 1;
                        break;
                    }
                    case WEST: {
                        step[0] = -1;
                        break;
                    }
                    case UP: {
                        step[1] = 1;
                        break;
                    }
                    case DOWN: {
                        step[1] = -1;
                    }
                }
                BlockPos tarPos = null;
                int currentEssence = (Integer)state.getValue((Property)EssenceFunnel.essenceLevel);
                boolean essenceHasChanged = false;
                BlockState belowState = level.getBlockState(pos.below(1));
                if (currentEssence > 0) {
                    for (int i = 0; i < 10; ++i) {
                        for (int s = 0; s < 3; ++s) {
                            int n = s;
                            tar[n] = tar[n] + step[s];
                        }
                        if (!level.getBlockState(pos.offset(tar[0], tar[1], tar[2])).is(AbyssTechBlocks.ESSENCE_JAR) && !level.getBlockState(pos.offset(tar[0], tar[1], tar[2])).is(AbyssTechBlocks.ESSENCE_FUNNEL)) continue;
                        tarPos = pos.offset(tar[0], tar[1], tar[2]);
                        break;
                    }
                    if (tarPos != null) {
                        BlockState tarState = level.getBlockState(tarPos);
                        BlockEntity blockEntity = level.getBlockEntity(tarPos);
                        if (blockEntity instanceof EssenceJarBlockEntity) {
                            EssenceJarBlockEntity essenceJarBlock22 = (EssenceJarBlockEntity)blockEntity;
                            int tarEssence = essenceJarBlock22.getEssence();
                            if (tarEssence < 500) {
                                essenceJarBlock22.setEssence(essenceJarBlock22.getEssence() + 1);
                                essenceHasChanged = true;
                            }
                        } else {
                            int tarEssence = (Integer)tarState.getValue((Property)EssenceFunnel.essenceLevel);
                            if (tarEssence < 2) {
                                level.setBlockAndUpdate(tarPos, (BlockState)tarState.setValue((Property)EssenceFunnel.essenceLevel, (Comparable)Integer.valueOf(tarEssence + 1)));
                                essenceHasChanged = true;
                            }
                        }
                        if (essenceHasChanged) {
                            --currentEssence;
                            AbyssTechUtility.drawPathToTarget(level, pos, tarPos, 0.1f, AbyssTechParticles.ESSENCE_BEAM_PARTICLES.get());
                        }
                    }
                }
                if (belowState.is(AbyssTechBlocks.ESSENCE_JAR) && state.getValue((Property)EssenceFunnel.FACING) != Direction.DOWN && (essenceJarBlock22 = level.getBlockEntity(pos.below(1))) instanceof EssenceJarBlockEntity && (belowEssence = (essenceJarBlock = (EssenceJarBlockEntity)essenceJarBlock22).getEssence()) > 0 && currentEssence < 2) {
                    essenceJarBlock.setEssence(essenceJarBlock.getEssence() - 1);
                    ++currentEssence;
                    essenceHasChanged = true;
                }
                if (essenceHasChanged) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EssenceFunnel.essenceLevel, (Comparable)Integer.valueOf(currentEssence)));
                }
            }
        }
    }
}

