/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class EssenceJarBlockEntity
extends AbstractEssenceMachine {
    private int jarEssenceAmount = 0;
    private final int maxEssence = 500;
    private final Random random = new Random();
    private final int tickRate = 20;
    private int currentTickRate = 20;
    private int tickCounter = this.random.nextInt(0, 19);
    private float cubeBobY = 0.0f;
    private boolean marginY = true;

    public EssenceJarBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.ESSENCE_JAR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.jarEssenceAmount = pTag.getInt("jar_essence_amount");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("jar_essence_amount", this.jarEssenceAmount);
        super.saveAdditional(pTag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.tickCounter = 0;
                level.setBlockAndUpdate(pos, state);
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 20, 12, 4);
                if (level.getBlockState(pos.below()).is((Block)AbyssTechBlocks.CREATIVE_JAR_STABILIZER.get())) {
                    this.setEssence(500);
                }
                if (this.getEssence() < 500) {
                    int searchRadius = 4;
                    this.searchTakeEssencePillar(level, pos, searchRadius, 1);
                } else {
                    BlockState blockBelow = level.getBlockState(pos.below(1));
                    if (!blockBelow.is(AbyssTechTags.Blocks.JAR_STABILIZER_LIKE)) {
                        level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
                        level.setBlockAndUpdate(pos, ((Block)AbyssTechBlocks.DISPLACED_VOID.get()).defaultBlockState());
                    }
                }
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public int getEssence() {
        return this.jarEssenceAmount;
    }

    public void setEssence(int amount) {
        this.jarEssenceAmount = amount;
    }

    public int getMaxEssence() {
        return 500;
    }

    public float bobSubstance(float bobSpeed) {
        float slow = this.cubeBobY < 0.02f || this.cubeBobY > 0.03f ? (this.cubeBobY < 0.01f || this.cubeBobY > 0.04f ? (this.cubeBobY < 0.005f || this.cubeBobY > 0.045f ? bobSpeed : bobSpeed * 2.0f) : bobSpeed * 3.0f) : bobSpeed * 4.0f;
        this.cubeBobY = this.marginY ? this.cubeBobY + slow : this.cubeBobY - slow;
        this.marginY = !(this.cubeBobY > 0.05f) && (this.cubeBobY < 0.0f || this.marginY);
        return this.cubeBobY;
    }
}

