/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.FermentationBarrel;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private int fermentingProgress = 0;
    private static final Map<Item, Item> FERMENTATION_MAP = Map.ofEntries(Map.entry(AbyssTechBlocks.TORPOR_CAP.asItem(), (Item)AbyssTechItems.TORPOR_CAP_FERMENTED.get()), Map.entry(AbyssTechBlocks.SOL_MOREL.asItem(), (Item)AbyssTechItems.SOL_MOREL_FERMENTED.get()), Map.entry(AbyssTechBlocks.CREEPING_MOREL.asItem(), (Item)AbyssTechItems.CREEPING_MOREL_FERMENTED.get()), Map.entry(AbyssTechBlocks.GUT_PUFFBALL.asItem(), (Item)AbyssTechItems.GUT_PUFFBALL_FERMENTED.get()), Map.entry(AbyssTechBlocks.MUSH_PUFFBALL.asItem(), (Item)AbyssTechItems.MUSH_PUFFBALL_FERMENTED.get()), Map.entry(AbyssTechBlocks.WEEPING_CAP.asItem(), (Item)AbyssTechItems.WEEPING_CAP_FERMENTED.get()), Map.entry((Item)AbyssTechItems.VIBRANT_WHEAT.get(), (Item)AbyssTechItems.VIBRANT_WHEAT_FERMENTED.get()), Map.entry((Item)AbyssTechItems.ROYAL_HONEY_DROP.get(), (Item)AbyssTechItems.ROYAL_HONEY_FERMENTED.get()), Map.entry(Items.MILK_BUCKET, (Item)AbyssTechItems.CHEESE.get()));
    Random random = new Random();
    private final int tickRate = 60;
    private int currentTick = this.random.nextInt(0, 59);
    private final int fermentingProgressMax = 100;

    public FermentationBarrelBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.FERMENTATION_BARREL_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty() && FERMENTATION_MAP.containsValue(stack.getItem());
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("abyssal_fermenting_progress", this.fermentingProgress);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fermentingProgress = tag.getInt("abyssal_fermenting_progress");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FermentationBarrelBlockEntity) {
            FermentationBarrelBlockEntity fermentationBarrelBe = (FermentationBarrelBlockEntity)blockEntity;
            if (this.currentTick >= 60) {
                this.currentTick = 0;
                if (!fermentationBarrelBe.isEmpty()) {
                    ItemStack itemInBarrel;
                    if (!((Boolean)state.getValue((Property)FermentationBarrel.hasItem)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FermentationBarrel.hasItem, (Comparable)Boolean.valueOf(true)));
                    }
                    if (FERMENTATION_MAP.containsKey((itemInBarrel = fermentationBarrelBe.getItem(0)).getItem())) {
                        ++this.fermentingProgress;
                        AbyssTechUtility.sendSimpleEffects(level, pos, 2, 1.2, ParticleTypes.BUBBLE, AbyssTechSounds.FERMENTING.get());
                        if (this.fermentingProgress >= 100) {
                            ItemStack itemResult = fermentationBarrelBe.getItem(0);
                            if (itemResult.is(Items.MILK_BUCKET)) {
                                AbyssTechUtility.ItemSimpleSpawn(level, pos, Items.BUCKET, 0.0, -1.0, 0.0);
                            }
                            fermentationBarrelBe.clearContent();
                            fermentationBarrelBe.setItem(0, FERMENTATION_MAP.get(itemResult.getItem()).getDefaultInstance());
                            this.fermentingProgress = 0;
                            AbyssTechUtility.sendSimpleEffects(level, pos, 8, 1.2, ParticleTypes.BUBBLE, AbyssTechSounds.FERMENTED.get());
                        }
                    }
                } else {
                    if (this.fermentingProgress > 0) {
                        this.fermentingProgress = 0;
                    }
                    if (((Boolean)state.getValue((Property)FermentationBarrel.hasItem)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FermentationBarrel.hasItem, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
            ++this.currentTick;
        }
    }
}

