/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.InstabilityDetectorBlock;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class InstabilityDetectorBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 40;
    private int tickCounter = this.random.nextInt(0, 39);

    public InstabilityDetectorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.INSTABILITY_DETECTOR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= 40) {
                this.tickCounter = 0;
                int currentDisplayValue = (Integer)level.getBlockState(pos).getValue((Property)InstabilityDetectorBlock.instabilityAmount);
                int currentInstability = AbyssTechUtility.getThresholdIntegrity(level, pos);
                int displayInstability = currentInstability < 1000 ? 0 : (currentInstability < 5000 ? 1 : (currentInstability < 10000 ? 2 : 3));
                int redstonePower = Math.max(0, Math.min(15, currentInstability / 100));
                if (redstonePower != (Integer)state.getValue((Property)InstabilityDetectorBlock.redstonePower)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)InstabilityDetectorBlock.redstonePower, (Comparable)Integer.valueOf(redstonePower)));
                }
                if (currentDisplayValue != displayInstability) {
                    level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)InstabilityDetectorBlock.instabilityAmount, (Comparable)Integer.valueOf(displayInstability)));
                }
                if (((Boolean)level.getBlockState(pos).getValue((Property)InstabilityDetectorBlock.noisy)).booleanValue() && currentDisplayValue != 0) {
                    level.playSound(null, pos, AbyssTechSounds.UNSTABLE_DETECT.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                }
            }
        }
    }
}

