/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.BaseDirectionalBlock;
import net.quasar.abysstech.block.custom.InstabilityStabilizer;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class InstabilityStabilizerBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 100;
    private int currentTickRate = 100;
    private int tickCounter = this.random.nextInt(0, 99);
    private int extraScrub = 0;
    private float animatePartYPos = 1.2f;

    public InstabilityStabilizerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.INSTABILITY_STABILIZER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putFloat("abyss_thresher.part_y", this.animatePartYPos);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.animatePartYPos = tag.getFloat("abyss_thresher.part_y");
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            this.updateAnimatePart(level, pos, state);
            if (this.tickCounter > this.currentTickRate) {
                this.tickCounter = 0;
                BlockState aboveState = level.getBlockState(pos.above(1));
                int upgradeTop = aboveState.is(AbyssTechBlocks.THRESHOLD_SUTURE) ? 1 : (aboveState.is(AbyssTechBlocks.EIDOLON_THRESHER) ? 2 : 0);
                this.currentTickRate = upgradeTop > 0 ? 50 : AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 100, 50, 20);
                int chunkInstability = AbyssTechUtility.getThresholdIntegrity(level, pos);
                int filterState = (Integer)state.getValue((Property)InstabilityStabilizer.gunkLevel);
                if (chunkInstability > 0 && filterState < 20 && ((Boolean)state.getValue((Property)InstabilityStabilizer.cleanFilter)).booleanValue()) {
                    this.scrub(level, pos, state, filterState, upgradeTop);
                }
                if (filterState < 20 && ((Boolean)state.getValue((Property)InstabilityStabilizer.cleanFilter)).booleanValue() && upgradeTop == 2) {
                    this.thresher(level, pos);
                }
            }
        }
    }

    private void thresher(Level level, BlockPos pos) {
        int radius = 8;
        block0: for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    Block[][] blocks;
                    BlockState tState = level.getBlockState(pos.offset(x, y, z));
                    if (tState.is(AbyssTechTags.Blocks.SLUDGE_LIKE)) {
                        level.setBlockAndUpdate(pos.offset(x, y, z), ((Block)AbyssTechBlocks.EIDOLON_CREEP.get()).defaultBlockState());
                        break block0;
                    }
                    if (!tState.is(AbyssTechBlocks.OUTER_SLUDGE_CARPET) && !tState.is(AbyssTechBlocks.OUTER_SLUDGE_EMERGING) && !tState.is(AbyssTechTags.Blocks.SLUDGE_STEMS)) continue;
                    for (Block[] b : blocks = new Block[][]{{(Block)AbyssTechBlocks.OUTER_SLUDGE_CARPET.get(), (Block)AbyssTechBlocks.EIDOLON_CAIRN.get()}, {(Block)AbyssTechBlocks.OUTER_SLUDGE_EMERGING.get(), (Block)AbyssTechBlocks.TALL_EIDOLON_CAIRN.get()}, {(Block)AbyssTechBlocks.OUTER_SLUDGE_BALLOON_STEM.get(), (Block)AbyssTechBlocks.EIDOLON_PILLAR.get()}, {(Block)AbyssTechBlocks.OUTER_SLUDGE_DENDRITE.get(), (Block)AbyssTechBlocks.EIDOLON_PILLAR.get()}}) {
                        if (!tState.is(b[0])) continue;
                        if (b[0] instanceof BaseDirectionalBlock) {
                            Direction d = (Direction)tState.getValue((Property)BaseDirectionalBlock.FACING);
                            level.setBlockAndUpdate(pos.offset(x, y, z), (BlockState)b[1].defaultBlockState().setValue((Property)BaseDirectionalBlock.FACING, (Comparable)d));
                            break block0;
                        }
                        level.setBlockAndUpdate(pos.offset(x, y, z), b[1].defaultBlockState());
                        break block0;
                    }
                }
            }
        }
        level.playSound(null, pos, AbyssTechSounds.THUMP.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
    }

    private void scrub(Level level, BlockPos pos, BlockState state, int filterState, int upgraded) {
        AbyssTechUtility.setThresholdIntegrity(level, pos, 1, false);
        if (this.extraScrub < (upgraded > 0 ? 9 * upgraded : 3)) {
            ++this.extraScrub;
        } else {
            this.updateState(level, pos, state, filterState);
        }
    }

    private void updateState(Level level, BlockPos pos, BlockState state, int filterState) {
        if (filterState >= 19) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)InstabilityStabilizer.gunkLevel, (Comparable)Integer.valueOf(filterState + 1))).setValue((Property)InstabilityStabilizer.cleanFilter, (Comparable)Boolean.valueOf(false)));
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)InstabilityStabilizer.gunkLevel, (Comparable)Integer.valueOf(filterState + 1)));
        }
        if (this.extraScrub != 0) {
            this.extraScrub = 0;
        }
    }

    private void updateAnimatePart(Level level, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos.above(1)).is(AbyssTechBlocks.EIDOLON_THRESHER)) {
            if (((Boolean)state.getValue((Property)InstabilityStabilizer.cleanFilter)).booleanValue()) {
                if (this.tickCounter >= this.currentTickRate - 8) {
                    if (this.animatePartYPos > 1.2f) {
                        this.animatePartYPos -= 0.2f;
                    }
                } else {
                    this.animatePartYPos += 0.018f;
                }
                if (this.tickCounter >= this.currentTickRate) {
                    this.animatePartYPos = 1.2f;
                }
                level.sendBlockUpdated(pos, state, state, 3);
            }
        } else if (this.animatePartYPos > 1.2f) {
            this.animatePartYPos = 1.2f;
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public float getAnimatePartYPos() {
        return this.animatePartYPos;
    }
}

