/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MagGlass;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class MagGlassBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 5;
    private int tickCounter = this.random.nextInt(0, 4);
    private int lightType = 0;
    private int lightAmount = 0;
    private int lightDist = 0;

    public MagGlassBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.MAG_GLASS_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("mag.light_amount", this.lightAmount);
        tag.putInt("mag.light_type", this.lightType);
        tag.putInt("mag.light_dist", this.lightDist);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.lightAmount = tag.getInt("mag.light_amount");
        this.lightType = tag.getInt("mag.light_type");
        this.lightDist = tag.getInt("mag.light_dist");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof MagGlassBlockEntity) {
            MagGlassBlockEntity studyBe = (MagGlassBlockEntity)blockEntity;
            ++this.tickCounter;
            if (this.tickCounter > 5) {
                this.tickCounter = 0;
                this.lightBlockingDist(level, state, pos);
                this.checkAndUpdateLightData(level, state, pos);
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    private void checkAndUpdateLightData(Level level, BlockState state, BlockPos pos) {
        int lightType = 0;
        if (level.canSeeSky(pos.offset(0, 1, 0))) {
            lightType = level.isDay() ? 1 : 2;
        } else {
            int[] off = new int[]{0, 0, 0};
            BlockPos tarPos = pos;
            for (int i = 1; i < 5; ++i) {
                Arrays.fill(off, 0);
                switch ((Direction)state.getValue((Property)MagGlass.FACING)) {
                    case NORTH: {
                        off[2] = i;
                        break;
                    }
                    case SOUTH: {
                        off[2] = -i;
                        break;
                    }
                    case EAST: {
                        off[0] = -i;
                        break;
                    }
                    case WEST: {
                        off[0] = i;
                        break;
                    }
                    case UP: {
                        off[1] = -i;
                        break;
                    }
                    default: {
                        off[1] = i;
                    }
                }
                tarPos = pos.offset(off[0], off[1], off[2]);
                if (level.getBlockState(tarPos).is(Blocks.GLOWSTONE)) {
                    lightType = 3;
                    break;
                }
                if (!level.getBlockState(tarPos).is(AbyssTechBlocks.DISPLACED_VOID)) continue;
                lightType = 4;
            }
        }
        this.setLightType(lightType);
        this.setLightAmount((Integer)state.getValue((Property)MagGlass.Mag) + 1);
    }

    public void lightBlockingDist(Level level, BlockState state, BlockPos pos) {
        int dist = 0;
        int[] off = new int[]{0, 0, 0};
        int i = 1;
        while (i < 6) {
            Arrays.fill(off, 0);
            switch ((Direction)state.getValue((Property)MagGlass.FACING)) {
                case NORTH: {
                    off[2] = -i;
                    break;
                }
                case SOUTH: {
                    off[2] = i;
                    break;
                }
                case EAST: {
                    off[0] = i;
                    break;
                }
                case WEST: {
                    off[0] = -i;
                    break;
                }
                case UP: {
                    off[1] = i;
                    break;
                }
                default: {
                    off[1] = -i;
                }
            }
            dist = i++;
            BlockPos tarPos = pos.offset(off[0], off[1], off[2]);
            if (level.getBlockState(tarPos).isAir()) continue;
            if (level.getBlockState(tarPos).is(AbyssTechBlocks.STAR_LANTERN)) {
                for (int p = 0; p < 4; ++p) {
                    SimpleParticleType toSend = switch (this.getLightType()) {
                        case 1 -> AbyssTechParticles.SPARKLE_SOL.get();
                        case 2 -> AbyssTechParticles.SPARKLE_LUNAR.get();
                        case 4 -> AbyssTechParticles.SPARKLE_OUTER.get();
                        default -> AbyssTechParticles.SPARKLE_NORM.get();
                    };
                    ((ServerLevel)level).sendParticles((ParticleOptions)toSend, (double)(tarPos.getX() + (this.random.nextInt(40) - 20)), (double)(tarPos.getY() + (this.random.nextInt(20) - 10)), (double)(tarPos.getZ() + (this.random.nextInt(40) - 20)), 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            if (this.getLightType() != 4) break;
            BlockState toPlace = null;
            if (level.getBlockState(tarPos).is(AbyssTechBlocks.MORT_STONE_BRICKS_WINDOW)) {
                toPlace = ((Block)AbyssTechBlocks.OUTER_GAZED_GLASS_RED.get()).defaultBlockState();
            } else if (level.getBlockState(tarPos).is(BlockTags.STONE_ORE_REPLACEABLES)) {
                toPlace = ((Block)AbyssTechBlocks.FORGOTTEN_STONE.get()).defaultBlockState();
            } else if (level.getBlockState(tarPos).is(BlockTags.PLANKS)) {
                toPlace = ((Block)AbyssTechBlocks.FORGOTTEN_PLANKS.get()).defaultBlockState();
            }
            if (toPlace == null) break;
            level.setBlockAndUpdate(tarPos, toPlace);
            level.playSound(null, pos, AbyssTechSounds.MAGIC_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.0f);
            break;
        }
        this.setLightDist(dist);
    }

    private void setLightDist(int lightDist) {
        this.lightDist = lightDist;
    }

    public int getLightDist() {
        return this.lightDist;
    }

    public int getLightType() {
        return this.lightType;
    }

    public void setLightType(int type) {
        this.lightType = type;
    }

    public int getLightAmount() {
        return this.lightAmount;
    }

    public void setLightAmount(int amount) {
        this.lightAmount = amount;
    }
}

