/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.Mixer;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.item.custom.Mantra;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class MixerBlockEntity
extends AbstractEssenceMachine
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    Random random = new Random();
    private final int tickRate = 20;
    private int currentTick = this.random.nextInt(0, 19);
    private int craftTick = 0;
    private final int maxCraftTick = 10;
    private final int maxCraftTickTears = 5;

    public MixerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.MIXER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return Arrays.asList(this.getTears()).contains(this.getItem(slot).getItem()) || this.getItem(slot).getItem() instanceof Mantra;
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.currentTick;
            if (this.currentTick >= 20) {
                this.currentTick = 0;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof MixerBlockEntity) {
                    MixerBlockEntity mixerBase = (MixerBlockEntity)blockEntity;
                    if (!mixerBase.isEmpty()) {
                        if (mixerBase.getItem(0).getItem() instanceof Mantra) {
                            Item[] validIngredient = new Item[]{(Item)AbyssTechItems.DISTILLATE_TORPOR.get(), (Item)AbyssTechItems.DISTILLATE_WEEPING.get(), (Item)AbyssTechItems.DISTILLATE_GUT.get(), (Item)AbyssTechItems.DISTILLATE_MUSH.get(), (Item)AbyssTechItems.DISTILLATE_CREEPING.get(), (Item)AbyssTechItems.DISTILLATE_SOL.get(), (Item)AbyssTechItems.DISTILLATE_VIBRANT.get(), (Item)AbyssTechItems.DISTILLATE_ROYAL.get()};
                            ItemStack[] chamberItems = this.getChamberItemsArray(level, pos);
                            if (chamberItems[0] != null && this.searchTakeEssence(level, pos, 6, 1)) {
                                ++this.craftTick;
                                this.setFunctionTypeProperty(level, state, pos, 2, 10);
                                AbyssTechUtility.sendSimpleEffects(level, pos, 2, 4.2, ParticleTypes.BUBBLE, AbyssTechSounds.DISTILLING.get());
                                if (this.craftTick >= 10) {
                                    this.craftTick = 0;
                                    this.setFunctionTypeProperty(level, state, pos, 0, 10);
                                    AbyssTechUtility.sendSimpleEffects(level, pos, 8, 4.2, ParticleTypes.CAMPFIRE_COSY_SMOKE, SoundEvents.FIRE_EXTINGUISH);
                                    if (mixerBase.getItem(0).getItem() instanceof Mantra) {
                                        int stainType = this.ingredientIterator(chamberItems[0], validIngredient);
                                        int stainScent = -1;
                                        int stainSaturation = -1;
                                        if (chamberItems[1] != null) {
                                            stainScent = this.ingredientIterator(chamberItems[1], validIngredient);
                                        }
                                        if (chamberItems[2] != null) {
                                            stainSaturation = this.ingredientIterator(chamberItems[2], validIngredient);
                                        }
                                        mixerBase.getItem(0).set(AbyssTechDataComponentTypes.STAIN_TYPE, (Object)(stainType + 1));
                                        mixerBase.getItem(0).set(AbyssTechDataComponentTypes.STAIN_SCENT, (Object)(stainScent == -1 ? 0 : stainScent + 1));
                                        mixerBase.getItem(0).set(AbyssTechDataComponentTypes.STAIN_SATURATION, (Object)(stainSaturation == -1 ? 0 : stainSaturation + 1));
                                    }
                                    this.clearValidChamberItems(level, pos, chamberItems);
                                }
                            }
                        } else {
                            List<TagKey> tags = List.of(AbyssTechTags.Items.HAS_FLOURISHING_ECHO, AbyssTechTags.Items.HAS_SANGUINE_ECHO, AbyssTechTags.Items.HAS_STRANGE_ECHO, AbyssTechTags.Items.HAS_MUNDANE_ECHO, AbyssTechTags.Items.HAS_INFERNAL_ECHO, AbyssTechTags.Items.HAS_EPHEMERAL_ECHO, AbyssTechTags.Items.HAS_DEEP_ECHO, AbyssTechTags.Items.HAS_MAGIC_ECHO, AbyssTechTags.Items.HAS_ALIEN_ECHO, AbyssTechTags.Items.HAS_AVARICE_ECHO, AbyssTechTags.Items.HAS_MAD_ECHO);
                            Item[] tears = this.getTears();
                            for (int i = 0; i < tags.size(); ++i) {
                                if (!mixerBase.getItem(0).is(tags.get(i))) continue;
                                ++this.craftTick;
                                this.setFunctionTypeProperty(level, state, pos, 1, 5);
                                AbyssTechUtility.sendSimpleEffects(level, pos, 2, 1.2, ParticleTypes.BUBBLE, AbyssTechSounds.DISTILLING.get());
                                if (this.craftTick >= 5) {
                                    this.craftTick = 0;
                                    this.setFunctionTypeProperty(level, state, pos, 0, 5);
                                    if (this.searchTakeEssence(level, pos, 6, 1, 1)) {
                                        mixerBase.clearContent();
                                        mixerBase.setItem(0, tears[i].getDefaultInstance());
                                        AbyssTechUtility.sendSimpleEffects(level, pos, 8, 1.2, ParticleTypes.CAMPFIRE_COSY_SMOKE, SoundEvents.FIRE_EXTINGUISH);
                                    }
                                }
                                break;
                            }
                        }
                    } else if (this.craftTick != 0) {
                        this.craftTick = 0;
                    }
                }
            }
        }
    }

    private void setFunctionTypeProperty(Level level, BlockState state, BlockPos pos, int toSet, int tickThreshold) {
        if (this.craftTick < tickThreshold && (Integer)state.getValue((Property)Mixer.functionType) != toSet) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Mixer.functionType, (Comparable)Integer.valueOf(toSet)));
        }
    }

    private int ingredientIterator(ItemStack toCompare, Item[] arrayItems) {
        int toReturn = 0;
        for (int i = 0; i < arrayItems.length; ++i) {
            if (!toCompare.is(arrayItems[i])) continue;
            toReturn = i;
            break;
        }
        return toReturn;
    }

    private ItemStack[] getChamberItemsArray(Level level, BlockPos pos) {
        ItemStack[] itemArray = new ItemStack[]{null, null, null};
        for (int i = 0; i < 3; ++i) {
            SingleItemContainerBlockEntity chamber;
            BlockEntity blockEntity;
            if (!level.getBlockState(pos.above(i + 1)).is(AbyssTechBlocks.MIXER_CHAMBER) || !((blockEntity = level.getBlockEntity(pos.above(i + 1))) instanceof SingleItemContainerBlockEntity) || (chamber = (SingleItemContainerBlockEntity)blockEntity).isEmpty()) continue;
            itemArray[i] = chamber.getItem(0);
        }
        return itemArray;
    }

    private void clearValidChamberItems(Level level, BlockPos pos, ItemStack[] ingredientsUsed) {
        block0: for (int m = 0; m < 3; ++m) {
            SingleItemContainerBlockEntity chamber;
            BlockEntity blockEntity;
            if (!level.getBlockState(pos.above(m + 1)).is(AbyssTechBlocks.MIXER_CHAMBER) || !((blockEntity = level.getBlockEntity(pos.above(m + 1))) instanceof SingleItemContainerBlockEntity) || (chamber = (SingleItemContainerBlockEntity)blockEntity).isEmpty()) continue;
            for (int i = 0; i < ingredientsUsed.length; ++i) {
                if (!chamber.getItem(0).is(ingredientsUsed[m].getItem())) continue;
                chamber.clearContent();
                continue block0;
            }
        }
    }

    private Item[] getTears() {
        return new Item[]{(Item)AbyssTechItems.FLOURISHING_TEAR.get(), (Item)AbyssTechItems.SANGUINE_TEAR.get(), (Item)AbyssTechItems.STRANGE_TEAR.get(), (Item)AbyssTechItems.MUNDANE_TEAR.get(), (Item)AbyssTechItems.INFERNAL_TEAR.get(), (Item)AbyssTechItems.EPHEMERAL_TEAR.get(), (Item)AbyssTechItems.DEEP_TEAR.get(), (Item)AbyssTechItems.MAGIC_TEAR.get(), (Item)AbyssTechItems.ALIEN_TEAR.get(), (Item)AbyssTechItems.AVARICE_TEAR.get(), (Item)AbyssTechItems.MAD_TEAR.get()};
    }
}

