/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.entity.AbysstechEntities;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class MortSeedingCoreBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 600;
    private int currentTickRate = 600;
    private int tickCounter = this.random.nextInt(0, 599);

    public MortSeedingCoreBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.MORT_SEEDING_CORE_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.tickCounter = 0;
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 600, 300, 150);
                this.currentTickRate = AbyssTechUtility.tickRateThresholdDivider(level, pos, this.currentTickRate, 500, 0.95f, 60);
                int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, 1, false, 6, 9, 9);
                int randomOffsetX = this.random.nextInt(5) - 2;
                int randomOffsetY = 0;
                int randomOffsetZ = this.random.nextInt(5) - 2;
                BlockPos randPos = pos.offset(randomOffsetX, randomOffsetY, randomOffsetZ);
                BlockState randBlock = level.getBlockState(randPos);
                Block[] seedBlocks = new Block[]{(Block)AbyssTechBlocks.MORT_STONE.get(), (Block)AbyssTechBlocks.COCOON.get(), Blocks.HAY_BLOCK};
                for (int i = 0; i < seedBlocks.length; ++i) {
                    if (!randBlock.is(seedBlocks[i]) || !this.searchTakeEssence(level, pos, searchRadius, 5, 1)) continue;
                    switch (i) {
                        case 1: {
                            level.removeBlock(randPos, false);
                            AbyssTechUtility.MobSimpleSpawn(level, randPos, AbysstechEntities.LADYBUG.get().create(level));
                            break;
                        }
                        case 2: {
                            level.setBlockAndUpdate(randPos, ((Block)AbyssTechBlocks.VIBRANT_WHEAT_BLOCK.get()).defaultBlockState());
                            break;
                        }
                        default: {
                            BlockState toPlace = this.random.nextBoolean() ? ((Block)AbyssTechBlocks.LIVELY_ORE.get()).defaultBlockState() : ((Block)AbyssTechBlocks.VIBRANT_ORE.get()).defaultBlockState();
                            level.setBlockAndUpdate(randPos, toPlace);
                        }
                    }
                    level.playSound(null, pos, AbyssTechSounds.MORT_SEEDING.get(), SoundSource.BLOCKS);
                }
            }
        }
    }
}

