/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.Mortar;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.item.AbyssTechItems;
import org.jetbrains.annotations.Nullable;

public class MortarBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private static final Map<Item, Item> MORTAR_MAP = Map.ofEntries(Map.entry((Item)AbyssTechItems.ROTTING_GEM.get(), (Item)AbyssTechItems.DECAYING_POWDER.get()), Map.entry((Item)AbyssTechItems.ROOTING_GEM.get(), (Item)AbyssTechItems.SPROUTING_POWDER.get()), Map.entry((Item)AbyssTechItems.BOUNDARY_GEM.get(), (Item)AbyssTechItems.STRANGE_POWDER.get()), Map.entry(AbyssTechBlocks.CHRYSANTHEMUM.asItem(), (Item)AbyssTechItems.CHRYSANTHEMUM_PASTE.get()), Map.entry(Items.GLOW_INK_SAC, (Item)AbyssTechItems.RADIANT_OOZE.get()), Map.entry(Items.CRYING_OBSIDIAN, (Item)AbyssTechItems.STYGIAN_OOZE.get()), Map.entry(Items.DIAMOND, (Item)AbyssTechItems.DIAMOND_POWDER.get()), Map.entry(AbyssTechBlocks.DAHLIA.asItem(), (Item)AbyssTechItems.DAHLIA_PASTE.get()), Map.entry((Item)AbyssTechItems.FADED_TEAR.get(), (Item)AbyssTechItems.FADED_TEAR_POWDER.get()), Map.entry(AbyssTechBlocks.CRYSTAL_DREAMING.asItem(), (Item)AbyssTechItems.DREAMING_CRYSTAL_POWDER.get()), Map.entry(AbyssTechBlocks.TORPOR_CAP.asItem(), (Item)AbyssTechItems.TORPOR_SPORES.get()), Map.entry(AbyssTechBlocks.EIDOLON_CREEP.asItem(), (Item)AbyssTechItems.EIDOLON_POWDER.get()));
    private int cooldown = 0;
    private int hasItemUpdateTick = 0;

    public MortarBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.MORTAR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty() && MORTAR_MAP.containsValue(stack.getItem());
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof MortarBlockEntity) {
            MortarBlockEntity mortarBlockEntity = (MortarBlockEntity)blockEntity;
            this.updateHasItem(level, pos, state, mortarBlockEntity);
            if (((Boolean)level.getBlockState(pos).getValue((Property)Mortar.progressCooldown)).booleanValue()) {
                ++this.cooldown;
                if (!mortarBlockEntity.isEmpty()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, mortarBlockEntity.getItem(0)), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.6f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, (double)0.05f);
                }
                if (this.cooldown >= 20) {
                    this.cooldown = 0;
                    int processProgress = (Integer)state.getValue((Property)Mortar.ingredientProgress);
                    if (!mortarBlockEntity.isEmpty()) {
                        if (processProgress < 4) {
                            ++processProgress;
                        } else if (MORTAR_MAP.containsKey(mortarBlockEntity.getItem(0).getItem())) {
                            ItemStack itemResult = mortarBlockEntity.getItem(0);
                            mortarBlockEntity.clearContent();
                            mortarBlockEntity.setItem(0, MORTAR_MAP.get(itemResult.getItem()).getDefaultInstance());
                            processProgress = 0;
                        }
                    }
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)Mortar.progressCooldown, (Comparable)Boolean.valueOf(false))).setValue((Property)Mortar.ingredientProgress, (Comparable)Integer.valueOf(processProgress)));
                }
            }
        }
    }

    private void updateHasItem(Level level, BlockPos pos, BlockState state, MortarBlockEntity blockEntity) {
        if (this.hasItemUpdateTick >= 10) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Mortar.hasItem, (Comparable)Boolean.valueOf(!blockEntity.isEmpty())));
            this.hasItemUpdateTick = 0;
        }
        ++this.hasItemUpdateTick;
    }
}

