/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.DisplacedVoid;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import org.jetbrains.annotations.Nullable;

public class PackerUnpackerBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    Random random = new Random();
    private final int tickRate = 10;
    private int currentTick = this.random.nextInt(0, 9);

    public PackerUnpackerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.PACKER_UNPACKER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty();
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof PackerUnpackerBlockEntity) {
            PackerUnpackerBlockEntity packerUnpackerBlockEntity = (PackerUnpackerBlockEntity)blockEntity;
            if (this.currentTick >= 10) {
                this.currentTick = 0;
                BlockEntity blockEntity2 = level.getBlockEntity(pos.above(1));
                if (blockEntity2 instanceof EssenceJarBlockEntity) {
                    EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity2;
                    int jarEssence = essenceJarBlock.getEssence();
                    ItemStack itemInInventory = packerUnpackerBlockEntity.getItem(0);
                    if (state.is(AbyssTechBlocks.ESSENCE_PACKER)) {
                        if (jarEssence > 0 && packerUnpackerBlockEntity.isEmpty()) {
                            essenceJarBlock.setEssence(jarEssence - 1);
                            packerUnpackerBlockEntity.setItem(0, AbyssTechItems.ABYSSAL_ESSENCE_AMPOULE.toStack());
                        }
                    } else if (jarEssence < 500 && itemInInventory.is(AbyssTechItems.ABYSSAL_ESSENCE_AMPOULE)) {
                        packerUnpackerBlockEntity.clearContent();
                        essenceJarBlock.setEssence(jarEssence + 1);
                    }
                } else {
                    BlockState blockTwoAbove = level.getBlockState(pos.above(2));
                    if (state.is(AbyssTechBlocks.ESSENCE_PACKER) && blockTwoAbove.is(AbyssTechBlocks.DISPLACED_VOID) && packerUnpackerBlockEntity.isEmpty()) {
                        int unstableAmount = (Integer)blockTwoAbove.getValue((Property)DisplacedVoid.unstable);
                        if (unstableAmount > 1) {
                            level.setBlockAndUpdate(pos.above(2), (BlockState)blockTwoAbove.setValue((Property)DisplacedVoid.unstable, (Comparable)Integer.valueOf(unstableAmount - 1)));
                        } else {
                            level.destroyBlock(pos.above(2), true);
                        }
                        if (this.random.nextInt(10) < 1) {
                            packerUnpackerBlockEntity.setItem(0, AbyssTechItems.ABYSSAL_ESSENCE_AMPOULE.toStack());
                        }
                    }
                }
            }
            ++this.currentTick;
        }
    }
}

