/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.PillarCoalescing;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.util.AbyssTechUtility;

public class PillarCoalescingBlockEntity
extends BlockEntity {
    private int pillarEssenceAmount = 0;
    private final int abyssEssenceMax = 20;
    private final Random random = new Random();
    private final int tickRate = 1200;
    private int currentTickRate = 1200;
    private int tickCounter = this.random.nextInt(0, 1199);

    public PillarCoalescingBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.PILLAR_COALESCING_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.pillarEssenceAmount = pTag.getInt("pillar_essence_amount");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("pillar_essence_amount", this.pillarEssenceAmount);
        super.saveAdditional(pTag, pRegistries);
    }

    public void tick(Level level, BlockPos pos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.tickCounter = 0;
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 2, true, 1200, 600, 300);
                this.currentTickRate = AbyssTechUtility.tickRateThresholdDivider(level, pos, this.currentTickRate, 1100, 0.95f, 100);
                if (this.pillarEssenceAmount < this.abyssEssenceMax && level.getBlockState(pos.above(1)).getBlock() == AbyssTechBlocks.PILLAR_UNTUNED.get() && level.getBlockState(pos.below(1)).getBlock() == AbyssTechBlocks.PILLAR_UNTUNED.get()) {
                    boolean isCrowded = false;
                    int searchRadius = 2;
                    if (level.getBlockState(pos.above(2)).getBlock() == AbyssTechBlocks.TUNING_CRYSTAL_EMBRACE.get()) {
                        searchRadius = 1;
                    }
                    int searchX = pos.getX() - searchRadius;
                    int searchY = pos.getY() - searchRadius;
                    int searchZ = pos.getZ() - searchRadius;
                    while (searchY <= pos.getY() + searchRadius) {
                        if (++searchX > pos.getX() + searchRadius) {
                            searchX = pos.getX() - searchRadius;
                            if (++searchZ > pos.getZ() + searchRadius) {
                                searchZ = pos.getZ() - searchRadius;
                                ++searchY;
                            }
                        }
                        BlockPos tarBlockPos = new BlockPos(searchX, searchY, searchZ);
                        BlockState checkBlock = level.getBlockState(tarBlockPos);
                        if (tarBlockPos.getX() == pos.getX() && tarBlockPos.getY() == pos.getY() && tarBlockPos.getZ() == pos.getZ() || !checkBlock.is((Block)AbyssTechBlocks.PILLAR_COALESCING.get())) continue;
                        isCrowded = true;
                        break;
                    }
                    if (!isCrowded) {
                        this.setEssence(this.getEssence() + 1);
                    }
                }
                this.updatePillar(level, pos);
            }
        }
    }

    public int getEssence() {
        return this.pillarEssenceAmount;
    }

    public void setEssence(int amount) {
        this.pillarEssenceAmount = amount;
    }

    public int getMaxEssence() {
        return this.abyssEssenceMax;
    }

    public void updatePillar(Level level, BlockPos pos) {
        if (((Integer)level.getBlockState(pos).getValue((Property)PillarCoalescing.essenceLevel)).intValue() != this.getEssence()) {
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)PillarCoalescing.essenceLevel, (Comparable)Integer.valueOf(this.getEssence())));
        }
    }
}

