/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.PillarConducting;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.PillarCoalescingBlockEntity;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class PillarConductingBlockEntity
extends BlockEntity {
    private int pillarEssenceAmount = 0;
    private final Random random = new Random();
    private final int tickRate = 200;
    private int currentTickRate = 200;
    private int tickCounter = this.random.nextInt(0, 199);
    private final int abyssEssenceMax = 100;

    public PillarConductingBlockEntity(BlockPos pillarPos, BlockState pillarBlockState) {
        super(AbyssTechBlockEntities.PILLAR_CONDUCTING_BLOCK_ENTITY.get(), pillarPos, pillarBlockState);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.pillarEssenceAmount = pTag.getInt("pillar_essence_amount");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("pillar_essence_amount", this.pillarEssenceAmount);
        super.saveAdditional(pTag, pRegistries);
    }

    public void tick(Level level, BlockPos pos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.tickCounter = 0;
                level.setBlockAndUpdate(pos, (BlockState)pState.setValue((Property)PillarConducting.essenceLevel, (Comparable)Integer.valueOf(Math.max(0, Math.min(5, this.getEssence() / 20)))));
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 2, true, 200, 100, 50);
                this.currentTickRate = AbyssTechUtility.tickRateThresholdDivider(level, pos, this.currentTickRate, 1100, 0.95f, 20);
                if (this.getEssence() < 100 && level.getBlockState(pos.above(1)).getBlock() == AbyssTechBlocks.PILLAR_UNTUNED.get() && level.getBlockState(pos.below(1)).getBlock() == AbyssTechBlocks.PILLAR_UNTUNED.get()) {
                    int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, 2, true, 3, 6, 9);
                    int totalEssenceCollected = 0;
                    block0: for (int x = -searchRadius; x <= searchRadius; ++x) {
                        for (int y = -searchRadius; y <= searchRadius; ++y) {
                            for (int z = -searchRadius; z <= searchRadius; ++z) {
                                PillarCoalescingBlockEntity pillarCoalescing;
                                BlockPos tarBlockPos = pos.offset(x, y, z);
                                BlockEntity blockEntity = level.getBlockEntity(tarBlockPos);
                                if (!(blockEntity instanceof PillarCoalescingBlockEntity) || (pillarCoalescing = (PillarCoalescingBlockEntity)blockEntity).getEssence() <= 0 || tarBlockPos.equals((Object)pos)) continue;
                                if (this.getEssence() + ++totalEssenceCollected >= 100) break block0;
                                pillarCoalescing.setEssence(pillarCoalescing.getEssence() - 1);
                                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)tarBlockPos.getX() + 0.5f), (double)((float)tarBlockPos.getY() + 0.5f), (double)((float)tarBlockPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                                level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, this.random.nextFloat(2.0f));
                            }
                        }
                    }
                    if (totalEssenceCollected > 0) {
                        this.setEssence(this.getEssence() + totalEssenceCollected);
                    }
                }
            }
        }
    }

    public int getEssence() {
        return this.pillarEssenceAmount;
    }

    public void setEssence(int amount) {
        this.pillarEssenceAmount = amount;
    }

    public int getMaxEssence() {
        return this.abyssEssenceMax;
    }
}

