/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.BaseDirectionalBlock;
import net.quasar.abysstech.block.custom.InstabilityStabilizer;
import net.quasar.abysstech.block.custom.Mortar;
import net.quasar.abysstech.block.custom.TallBlock;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.block.entity.custom.MortarBlockEntity;
import net.quasar.abysstech.block.entity.custom.TallEntityBlock;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class PlacerBlockEntity
extends AbstractEssenceMachine
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final Random random = new Random();
    private final int tickRate = 80;
    private int currentTickRate = 80;
    private int tickCounter = this.random.nextInt(0, 79);
    private final Block MirrorLively = (Block)AbyssTechBlocks.REFLECTOR_LIVELY.get();
    private final Block MirrorVibrant = (Block)AbyssTechBlocks.REFLECTOR_VIBRANT.get();

    public PlacerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.PLACER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        this.setChanged();
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.setChanged();
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        stack.shrink(amount);
        return (ItemStack)this.inventory.set(slot, (Object)stack);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.setChanged();
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return false;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        block3: {
            PlacerBlockEntity placerBlockEntity;
            int searchRadius;
            block4: {
                if (level.isClientSide()) break block3;
                ++this.tickCounter;
                if (this.tickCounter < this.currentTickRate) break block3;
                this.tickCounter = 0;
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 80, 40, 20);
                searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, 1, true, 6, 9, 12);
                BlockState bellowState = level.getBlockState(pos.below(1));
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof PlacerBlockEntity)) break block3;
                placerBlockEntity = (PlacerBlockEntity)blockEntity;
                if (!bellowState.is(AbyssTechBlocks.MORTAR)) break block4;
                BlockEntity blockEntity2 = level.getBlockEntity(pos.below(1));
                if (!(blockEntity2 instanceof MortarBlockEntity)) break block3;
                MortarBlockEntity mortarBlockEntity = (MortarBlockEntity)blockEntity2;
                if (((Boolean)bellowState.getValue((Property)Mortar.progressCooldown)).booleanValue() || mortarBlockEntity.isEmpty() || !placerBlockEntity.getItem(0).is(AbyssTechBlocks.PESTLE.asItem()) || !this.searchTakeEssence(level, pos, searchRadius, 1)) break block3;
                level.playSound(null, pos, AbyssTechSounds.MORTAR_GRIND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(pos.below(1), (BlockState)bellowState.setValue((Property)Mortar.progressCooldown, (Comparable)Boolean.valueOf(true)));
                break block3;
            }
            BlockState[][] checkMirrorAndToChange = new BlockState[][]{{level.getBlockState(pos.above(2)), level.getBlockState(pos.above(1))}, {level.getBlockState(pos.below(2)), level.getBlockState(pos.below(1))}, {level.getBlockState(pos.south(2)), level.getBlockState(pos.south(1))}, {level.getBlockState(pos.north(2)), level.getBlockState(pos.north(1))}, {level.getBlockState(pos.east(2)), level.getBlockState(pos.east(1))}, {level.getBlockState(pos.west(2)), level.getBlockState(pos.west(1))}};
            BlockPos[] targetBlockPos = new BlockPos[]{pos.offset(0, 1, 0), pos.offset(0, -1, 0), pos.offset(0, 0, 1), pos.offset(0, 0, -1), pos.offset(1, 0, 0), pos.offset(-1, 0, 0)};
            for (int i = 0; i < checkMirrorAndToChange.length; ++i) {
                Item item;
                if (!checkMirrorAndToChange[i][0].is(this.MirrorLively) && !checkMirrorAndToChange[i][0].is(this.MirrorVibrant)) continue;
                if (checkMirrorAndToChange[i][0].is(this.MirrorLively) && checkMirrorAndToChange[i][1].isAir()) {
                    BlockItem blockItem;
                    if (placerBlockEntity.isEmpty() || !((item = placerBlockEntity.getItem(0).getItem()) instanceof BlockItem) || !this.validCheck(level, targetBlockPos, i, blockItem = (BlockItem)item) || !this.searchTakeEssence(level, pos, searchRadius, 1, 1)) continue;
                    Block toPlace = blockItem.getBlock();
                    placerBlockEntity.removeItem(0, 1);
                    level.setBlockAndUpdate(targetBlockPos[i], this.placeBlockCheckForTube(level, targetBlockPos[i], toPlace.defaultBlockState()));
                    level.playSound(null, pos, AbyssTechSounds.MAGIC_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    continue;
                }
                if (!checkMirrorAndToChange[i][0].is(this.MirrorVibrant) || checkMirrorAndToChange[i][1].isAir() || !this.searchTakeEssence(level, pos, searchRadius, 1, 1)) continue;
                item = checkMirrorAndToChange[i][1].getBlock();
                if (item instanceof InstabilityStabilizer) {
                    InstabilityStabilizer stabilizer = (InstabilityStabilizer)item;
                    if (((Boolean)checkMirrorAndToChange[i][1].getValue((Property)InstabilityStabilizer.cleanFilter)).booleanValue() || placerBlockEntity.isEmpty() || !placerBlockEntity.getItem(0).is(AbyssTechItems.SCRUBBER_FILTER)) continue;
                    placerBlockEntity.removeItem(0, 1);
                    stabilizer.replaceFilter(level, targetBlockPos[i]);
                    continue;
                }
                AbyssTechUtility.dummyPlayerInteract(level, pos, targetBlockPos[i]);
            }
        }
    }

    private boolean validCheck(Level level, BlockPos[] targetBlockPos, int i, BlockItem toPlace) {
        BlockState state = level.getBlockState(targetBlockPos[i]);
        Block block = toPlace.getBlock();
        if (block instanceof TallBlock) {
            TallBlock tallBlock = (TallBlock)block;
            return tallBlock.validPlace(state, (LevelReader)level, targetBlockPos[i]);
        }
        block = toPlace.getBlock();
        if (block instanceof TallEntityBlock) {
            TallEntityBlock tallEntityBlock = (TallEntityBlock)block;
            return tallEntityBlock.validPlace(state, (LevelReader)level, targetBlockPos[i]);
        }
        return true;
    }

    private BlockState placeBlockCheckForTube(Level level, BlockPos posToPlace, BlockState blockToPlace) {
        if ((blockToPlace.is(AbyssTechBlocks.GEM_TUBE_RED) || blockToPlace.is(AbyssTechBlocks.GEM_TUBE_YELLOW) || blockToPlace.is(AbyssTechBlocks.GEM_TUBE_GREEN)) && (level.getBlockState(posToPlace.offset(1, 0, 0)).is(AbyssTechBlocks.ABYSSAL_ENGINE) || level.getBlockState(posToPlace.offset(-1, 0, 0)).is(AbyssTechBlocks.ABYSSAL_ENGINE))) {
            return (BlockState)blockToPlace.setValue((Property)BaseDirectionalBlock.FACING, (Comparable)Direction.WEST);
        }
        return blockToPlace.getBlock().defaultBlockState();
    }
}

