/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class PlantGrowerBlockEntity
extends AbstractEssenceMachine {
    private static final Map<Block, Block> GROWING_MAP = Map.of(Blocks.DANDELION, (Block)AbyssTechBlocks.COWS_LIP.get(), Blocks.POPPY, (Block)AbyssTechBlocks.CHRYSANTHEMUM.get(), Blocks.CORNFLOWER, (Block)AbyssTechBlocks.GLOBE_THISTLE.get(), Blocks.ALLIUM, (Block)AbyssTechBlocks.HYDRANGEA.get(), Blocks.OXEYE_DAISY, (Block)AbyssTechBlocks.GHOST_PIPE.get(), Blocks.TORCHFLOWER, (Block)AbyssTechBlocks.MARIGOLD.get());
    private final Random random = new Random();
    private final int tickRate = 200;
    private int tickCounter = this.random.nextInt(0, 199);
    private int currentTickRate = 200;

    public PlantGrowerBlockEntity(BlockPos pos, BlockState blockState) {
        super(AbyssTechBlockEntities.PLANT_GROWER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void tick(Level level, BlockPos pos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= this.currentTickRate) {
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pos, 1, true, 200, 100, 50);
                this.tickCounter = 0;
                int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, 1, false, 6, 9, 9);
                int randomOffsetX = this.random.nextInt(5) - 2;
                int randomOffsetY = this.random.nextInt(2) - 1;
                int randomOffsetZ = this.random.nextInt(5) - 2;
                BlockPos randPos = pos.offset(randomOffsetX, randomOffsetY, randomOffsetZ);
                Block blockToGrow = level.getBlockState(randPos).getBlock();
                if (this.searchTakeEssence(level, pos, searchRadius, 2, 1)) {
                    if (GROWING_MAP.containsKey(blockToGrow)) {
                        level.setBlockAndUpdate(randPos, GROWING_MAP.get(blockToGrow).defaultBlockState());
                    } else if (BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)randPos, null) || BoneMealItem.growWaterPlant((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)randPos, null)) {
                        level.levelEvent(2005, randPos, 0);
                    }
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)((float)randPos.getX() + 0.5f), (double)((float)randPos.getY() + 1.5f), (double)((float)randPos.getZ() + 0.5f), 4, 0.0, 0.0, 0.0, (double)0.08f);
                    level.playSound(null, randPos, AbyssTechSounds.MAGIC_GROW.get(), SoundSource.BLOCKS);
                }
            }
        }
    }
}

