/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.custom.PlayerProximityBlock;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.util.AbyssTechUtility;

public class PlayerProximityBlockEntity
extends BlockEntity {
    private final int tickRate = 20;
    private int currentTick = 0;

    public PlayerProximityBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.LILY_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.currentTick;
            if (this.currentTick >= this.tickRate) {
                this.currentTick = 0;
                List<Player> players = this.getPlayersNear(level, pos, 6);
                if (!players.isEmpty()) {
                    BlockPos playerPos = players.getFirst().getOnPos();
                    int dist = AbyssTechUtility.getDistOfTwoTargets(playerPos, pos);
                    int stage = dist < 3 ? 3 : (dist < 5 ? 2 : (dist < 7 ? 1 : 0));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PlayerProximityBlock.STAGE, (Comparable)Integer.valueOf(stage)));
                } else if ((Integer)state.getValue((Property)PlayerProximityBlock.STAGE) > 0) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PlayerProximityBlock.STAGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PlayerProximityBlock.STAGE) - 1)));
                }
            }
        }
    }

    private List<Player> getPlayersNear(Level level, BlockPos pos, int searchRadius) {
        return level.getEntitiesOfClass(Player.class, new AABB((double)(pos.getX() - searchRadius), (double)(pos.getY() - searchRadius), (double)(pos.getZ() - searchRadius), (double)(pos.getX() + searchRadius), (double)(pos.getY() + searchRadius), (double)(pos.getZ() + searchRadius)));
    }
}

