/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.Sigil;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.sound.AbyssTechSounds;

public class SigilBlockEntity
extends BlockEntity {
    private int onCooldown = 0;

    public SigilBlockEntity(BlockPos pos, BlockState blockState) {
        super(AbyssTechBlockEntities.SIGIL_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide() && ((Boolean)level.getBlockState(pPos).getValue((Property)Sigil.cooldown)).booleanValue()) {
            int sigilType = (Integer)level.getBlockState(pPos).getValue((Property)Sigil.sigilType);
            int cooldownMax = switch (sigilType) {
                case 0, 3 -> 60;
                case 1, 2 -> 80;
                case 4 -> 200;
                case 5 -> 600;
                default -> 40;
            };
            ++this.onCooldown;
            if (this.onCooldown >= cooldownMax) {
                level.setBlockAndUpdate(pPos, (BlockState)level.getBlockState(pPos).setValue((Property)Sigil.cooldown, (Comparable)Boolean.valueOf(false)));
                level.playSound(null, pPos, AbyssTechSounds.SIGIL_RECHARGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.onCooldown = 0;
            }
        }
    }
}

