/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.SingleItemContainer;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class SingleItemContainerBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private float itemRotation = 0.0f;
    private float itemBob = 0.0f;
    private boolean itemBobRising = true;
    private int hasItemUpdateTick = 0;

    public SingleItemContainerBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.SINGLE_ITEM_CONTAINER_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public float rotateRenderedItem() {
        this.itemRotation += 0.5f;
        if (this.itemRotation > 360.0f) {
            this.itemRotation = 0.0f;
        }
        return this.itemRotation;
    }

    public float bobRenderedItem() {
        float slow = this.itemBob < 0.05f || this.itemBob > 0.1f ? (this.itemBob < 0.03f || this.itemBob > 0.12f ? (this.itemBob < 0.01f || this.itemBob > 0.14f ? 0.001f : 0.002f) : 0.003f) : 0.004f;
        this.itemBob = this.itemBobRising ? this.itemBob + slow : this.itemBob - slow;
        this.itemBobRising = !(this.itemBob > 0.15f) && (this.itemBob < 0.0f || this.itemBobRising);
        return this.itemBob;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        if (this.level != null) {
            return this.level.getBlockState(this.getBlockPos()).is(AbyssTechBlocks.TEAR_VAT) ? this.getItem(slot).is(AbyssTechBlocks.FADED_TEAR_BLOCK.asItem()) : !this.getItem(slot).isEmpty();
        }
        return false;
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof SingleItemContainerBlockEntity) {
            SingleItemContainerBlockEntity singleItemContainerBlockEntity = (SingleItemContainerBlockEntity)blockEntity;
            if (this.hasItemUpdateTick >= 5) {
                this.hasItemUpdateTick = 0;
                AbyssTechUtility.updateItemRenderBooleanState(level, state, pos, SingleItemContainer.hasItem, singleItemContainerBlockEntity);
            }
            ++this.hasItemUpdateTick;
        }
    }
}

