/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MagGlass;
import net.quasar.abysstech.block.custom.Study;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.MagGlassBlockEntity;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import net.quasar.abysstech.util.special_recipe.AbyssTechRecipes;
import net.quasar.abysstech.util.special_recipe.StudyRecipe;
import org.jetbrains.annotations.Nullable;

public class StudyBlockEntity
extends BlockEntity
implements Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private float itemRotation = 0.0f;
    private float itemBob = 0.0f;
    private boolean itemBobRising = true;
    private final Random random = new Random();
    private final int tickRate = 5;
    private int tickCounter = this.random.nextInt(0, 4);
    private int inkAmount = 0;
    private int lightType = 0;
    private int lightAmount = 0;
    private int tearValue = 0;
    private int targetLightAmount = 0;
    private int targetTearValue = 0;
    private boolean winState = false;
    private boolean miniGameToggle = false;

    public StudyBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.STUDY_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public float rotateRenderedItem() {
        this.itemRotation += 0.5f;
        if (this.itemRotation > 360.0f) {
            this.itemRotation = 0.0f;
        }
        return this.itemRotation;
    }

    public float bobRenderedItem() {
        float slow = this.itemBob < 0.05f || this.itemBob > 0.1f ? (this.itemBob < 0.03f || this.itemBob > 0.12f ? (this.itemBob < 0.01f || this.itemBob > 0.14f ? 0.001f : 0.002f) : 0.003f) : 0.004f;
        this.itemBob = this.itemBobRising ? this.itemBob + slow : this.itemBob - slow;
        this.itemBobRising = !(this.itemBob > 0.15f) && (this.itemBob < 0.0f || this.itemBobRising);
        return this.itemBob;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.isEmpty()) {
            this.inventory.clear();
            this.setChanged();
            return stack;
        }
        this.setChanged();
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack.copyWithCount(1));
        this.setChanged();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.setChanged();
        return this.getItem(slot).isEmpty() || this.getItem(slot).getItem() == stack.getItem() && this.getItem(slot).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        this.setChanged();
        return !this.getItem(slot).isEmpty();
    }

    public boolean stillValid(Player player) {
        this.setChanged();
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("study.ink_amount", this.inkAmount);
        tag.putInt("study.tear_value", this.tearValue);
        tag.putInt("study.tear_target_value", this.targetTearValue);
        tag.putBoolean("study.mini_game_toggle", this.miniGameToggle);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inkAmount = tag.getInt("study.ink_amount");
        this.tearValue = tag.getInt("study.tear_value");
        this.targetTearValue = tag.getInt("study.tear_target_value");
        this.miniGameToggle = tag.getBoolean("study.mini_game_toggle");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof StudyBlockEntity) {
            StudyBlockEntity studyBe = (StudyBlockEntity)blockEntity;
            ++this.tickCounter;
            if (this.tickCounter > 5) {
                this.tickCounter = 0;
                int magSearchHeight = 3;
                this.getMagLightData(level, pos, magSearchHeight);
                if (this.lightType != 0 && !studyBe.isEmpty() && this.inkAmount > 0) {
                    ItemStack itemIn = studyBe.getItem(0);
                    List<StudyRecipe> recipes = AbyssTechRecipes.getAllRecipesOfType(StudyRecipe.class);
                    for (StudyRecipe studyRecipe : recipes) {
                        if (!itemIn.is(studyRecipe.getInput())) continue;
                        this.startAndCheckMiniGame(level, pos, state);
                        if (this.winState) {
                            studyBe.setItem(0, studyRecipe.getOutput()[this.random.nextInt(studyRecipe.getOutput().length)].getDefaultInstance());
                            this.resetMiniGame();
                            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                            level.playSound(null, pos, AbyssTechSounds.MAGIC_WOW.get(), SoundSource.BLOCKS);
                        }
                        break;
                    }
                } else {
                    this.resetMiniGame();
                }
                AbyssTechUtility.updateItemRenderBooleanState(level, state, pos, Study.hasItem, studyBe);
            }
        }
    }

    private void startAndCheckMiniGame(Level level, BlockPos pos, BlockState state) {
        if (!this.miniGameToggle) {
            this.miniGameToggle = true;
            this.randomizeTargets();
        } else if (this.lightAmount == this.targetLightAmount) {
            this.gatherTears(level, pos);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.5f), (double)((float)pos.getZ() + 0.5f), 2, 0.5, 0.5, 0.5, 0.0);
            if (this.tearValue == this.targetTearValue) {
                this.winState = true;
                --this.inkAmount;
            }
        }
    }

    private void gatherTears(Level level, BlockPos pos) {
        BlockPos[] directions;
        int[] tearValues = new int[]{-5, -4, -3, -2, -1, 1, 2, 3, 4, 5};
        Item[] tears = new Item[]{AbyssTechItems.MAD_TEAR.asItem(), AbyssTechItems.INFERNAL_TEAR.asItem(), AbyssTechItems.DEEP_TEAR.asItem(), AbyssTechItems.SANGUINE_TEAR.asItem(), AbyssTechItems.AVARICE_TEAR.asItem(), AbyssTechItems.MUNDANE_TEAR.asItem(), AbyssTechItems.FLOURISHING_TEAR.asItem(), AbyssTechItems.MAGIC_TEAR.asItem(), AbyssTechItems.EPHEMERAL_TEAR.asItem(), AbyssTechItems.ALIEN_TEAR.asItem()};
        block0: for (BlockPos directionPos : directions = new BlockPos[]{pos.north(1), pos.east(1), pos.south(1), pos.west(1)}) {
            BlockEntity blockEntity = level.getBlockEntity(directionPos);
            if (!(blockEntity instanceof SingleItemContainerBlockEntity)) continue;
            SingleItemContainerBlockEntity pedestal = (SingleItemContainerBlockEntity)blockEntity;
            if (!level.getBlockState(directionPos).is(AbyssTechBlocks.MORT_PEDESTAL) || pedestal.isEmpty()) continue;
            if (pedestal.getItem(0).is(AbyssTechItems.STRANGE_TEAR)) {
                this.tearValue *= -1;
                pedestal.removeItem(0, 1);
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                level.playSound(null, pos, AbyssTechSounds.STUDY_FOCUS.get(), SoundSource.BLOCKS);
                break;
            }
            for (int i = 0; i < tears.length; ++i) {
                if (!pedestal.getItem(0).is(tears[i])) continue;
                pedestal.removeItem(0, 1);
                this.tearValue += tearValues[i];
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                level.playSound(null, pos, AbyssTechSounds.STUDY_FOCUS.get(), SoundSource.BLOCKS);
                break block0;
            }
        }
    }

    private void randomizeTargets() {
        this.targetLightAmount = this.random.nextInt(3) + 1;
        this.targetTearValue = this.random.nextInt(40) - 20;
    }

    private void resetMiniGame() {
        this.miniGameToggle = false;
        this.winState = false;
        this.targetTearValue = 0;
        this.targetLightAmount = 0;
        this.tearValue = 0;
    }

    private void getMagLightData(Level level, BlockPos pos, int height) {
        int amount = 0;
        int type = 0;
        for (int i = 1; i < height + 1; ++i) {
            MagGlassBlockEntity magBe;
            Direction magDir;
            BlockEntity blockEntity = level.getBlockEntity(pos.offset(0, i, 0));
            if (!(blockEntity instanceof MagGlassBlockEntity) || (magDir = (Direction)(magBe = (MagGlassBlockEntity)blockEntity).getBlockState().getValue((Property)MagGlass.FACING)) != Direction.DOWN) continue;
            type = magBe.getLightType();
            amount = magBe.getLightAmount();
        }
        this.lightAmount = amount;
        this.lightType = type;
    }

    public void setInkAmount(int amount) {
        this.inkAmount = amount;
    }

    public int getInkAmount() {
        return this.inkAmount;
    }

    public boolean getMiniGameToggle() {
        return this.miniGameToggle;
    }

    public int getTearValue() {
        return this.tearValue;
    }

    public int getTargetTearValue() {
        return this.targetTearValue;
    }
}

