/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbstractEssenceMachine;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class TerraIncubatorBlockEntity
extends AbstractEssenceMachine {
    private final Random random = new Random();
    private final int tickRate = 160;
    private int currentTickRate = 160;
    private int tickCounter = this.random.nextInt(0, 159);

    public TerraIncubatorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.TERRA_INCUBATOR_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter > this.currentTickRate) {
                this.currentTickRate = AbyssTechUtility.flowTuneDetect(level, pPos, 1, true, 160, 80, 40);
                this.tickCounter = 0;
                int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pPos, 1, false, 6, 9, 9);
                for (int i = 0; i < 4; ++i) {
                    int offsetX = 0;
                    int offsetZ = 0;
                    switch (i) {
                        case 0: {
                            offsetX = 2;
                            break;
                        }
                        case 1: {
                            offsetX = -2;
                            break;
                        }
                        case 2: {
                            offsetZ = 2;
                            break;
                        }
                        case 3: {
                            offsetZ = -2;
                        }
                    }
                    if (level.getBlockState(pPos.offset(offsetX, 0, offsetZ)).getBlock() != AbyssTechBlocks.REFLECTOR_LIVELY.get() && level.getBlockState(pPos.offset(offsetX, 0, offsetZ)).getBlock() != AbyssTechBlocks.REFLECTOR_VIBRANT.get() || level.getBlockState(pPos.offset(offsetX / 2, 0, offsetZ / 2)).getBlock() != Blocks.AIR && level.getBlockState(pPos.offset(offsetX / 2, 0, offsetZ / 2)).getBlock() != Blocks.CAVE_AIR || !this.searchTakeEssence(level, pPos, searchRadius, 4, 2)) continue;
                    ResourceKey currentDimension = level.dimension();
                    BlockState stoneGenerated = null;
                    if (currentDimension.equals(Level.OVERWORLD)) {
                        if (pPos.getY() <= 0) {
                            stoneGenerated = this.random.nextInt(2) == 1 ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.TUFF.defaultBlockState();
                        } else {
                            randInt = this.random.nextInt(4);
                            stoneGenerated = switch (randInt) {
                                case 1 -> Blocks.ANDESITE.defaultBlockState();
                                case 2 -> Blocks.DIORITE.defaultBlockState();
                                case 3 -> Blocks.GRANITE.defaultBlockState();
                                default -> Blocks.STONE.defaultBlockState();
                            };
                        }
                    } else if (currentDimension.equals(Level.NETHER)) {
                        randInt = this.random.nextInt(3);
                        stoneGenerated = switch (randInt) {
                            case 1 -> Blocks.BLACKSTONE.defaultBlockState();
                            case 2 -> Blocks.BASALT.defaultBlockState();
                            default -> Blocks.NETHERRACK.defaultBlockState();
                        };
                    } else if (currentDimension.equals(Level.END)) {
                        stoneGenerated = Blocks.END_STONE.defaultBlockState();
                    }
                    if (stoneGenerated == null) continue;
                    level.setBlockAndUpdate(pPos.offset(offsetX / 2, 0, offsetZ / 2), stoneGenerated);
                    level.playSound(null, pPos, AbyssTechSounds.STONE_GEN.get(), SoundSource.BLOCKS);
                }
            }
        }
    }
}

