/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.BigBookLike;
import net.quasar.abysstech.block.custom.TapestryLike;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import org.jetbrains.annotations.Nullable;

public class TranslatorBlockEntity
extends BlockEntity {
    private final String noText = "No Text or Book";
    private String currentText;
    private float yRotation;
    private final int tickRate = 20;
    private int currentTick;

    public TranslatorBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.TRANSLATOR_BLOCK_ENTITY.get(), pPos, blockstate);
        this.currentText = this.noText = "No Text or Book";
        this.yRotation = 0.0f;
        this.tickRate = 20;
        this.currentTick = 0;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.yRotation = pTag.getFloat("abysstech.translator_rotation");
        this.currentText = pTag.getString("abysstech.translator_text");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putFloat("abysstech.translator_rotation", this.yRotation);
        pTag.putString("abysstech.translator_text", this.currentText);
        super.saveAdditional(pTag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            if (this.currentTick >= this.tickRate) {
                this.currentTick = 0;
                this.updateBlockAndTranslation(level, pos, state);
            }
            if (level.getBestNeighborSignal(pos) > 0) {
                this.rotateY();
                this.updateBlock(level, pos, state);
            }
            ++this.currentTick;
        }
    }

    private void rotateY() {
        this.yRotation = this.yRotation < 360.0f ? (this.yRotation += 0.04f) : 0.0f;
    }

    private void updateBlock(Level level, BlockPos pos, BlockState state) {
        level.sendBlockUpdated(pos, state, state, 3);
    }

    private void updateBlockAndTranslation(Level level, BlockPos pos, BlockState state) {
        boolean hasText;
        block5: {
            block4: {
                hasText = false;
                Block block = level.getBlockState(pos.above(1)).getBlock();
                if (!(block instanceof BigBookLike)) break block4;
                BigBookLike book = (BigBookLike)block;
                if (!((Boolean)level.getBlockState(pos.above(1)).getValue((Property)BigBookLike.boolState)).booleanValue()) break block5;
                if (Objects.equals(this.currentText, book.getBookText())) {
                    return;
                }
                this.currentText = book.getBookText();
                this.updateBlock(level, pos, state);
                hasText = true;
                break block5;
            }
            for (int i = 1; i < 4; ++i) {
                BlockState n = level.getBlockState(pos.above(i));
                Block block = n.getBlock();
                if (!(block instanceof TapestryLike)) continue;
                TapestryLike notes = (TapestryLike)block;
                if (!n.is(AbyssTechBlocks.NOTES_BLOCK)) continue;
                if (Objects.equals(this.currentText, notes.getLore(n))) {
                    return;
                }
                this.currentText = notes.getLore(n);
                this.updateBlock(level, pos, state);
                hasText = true;
                break;
            }
        }
        if (!hasText && !Objects.equals(this.currentText, this.noText)) {
            this.currentText = this.noText;
            this.updateBlock(level, pos, state);
        }
    }

    public String getText() {
        return this.currentText;
    }

    public float getYRotation() {
        return this.yRotation;
    }
}

