/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.WoodenFlesh;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class WoodenFleshBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private final int tickRate = 40;
    private int tickCounter = this.random.nextInt(0, 39);
    private BlockState logState = ((Block)AbyssTechBlocks.OLD_OAK_LOG.get()).defaultBlockState();

    public WoodenFleshBlockEntity(BlockPos pos, BlockState blockstate) {
        super(AbyssTechBlockEntities.WOODEN_FLESH_BLOCK_ENTITY.get(), pos, blockstate);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            ++this.tickCounter;
            if (this.tickCounter >= 40) {
                this.tickCounter = 0;
                boolean dropLogItem = false;
                if ((Integer)level.getBlockState(pos).getValue((Property)WoodenFlesh.spreadSearch) > 0) {
                    boolean logFound = false;
                    int offX = -1;
                    int offY = -1;
                    int offZ = -1;
                    for (int i = 0; i < 27; ++i) {
                        BlockPos tarPos = pos.offset(offX, offY, offZ);
                        if (level.getBlockState(tarPos).is(BlockTags.LOGS)) {
                            logFound = true;
                            BlockState logState = level.getBlockState(tarPos);
                            level.setBlockAndUpdate(tarPos, (BlockState)((Block)AbyssTechBlocks.WOODEN_FLESH.get()).defaultBlockState().setValue((Property)WoodenFlesh.spreadSearch, (Comparable)Integer.valueOf((Integer)level.getBlockState(pos).getValue((Property)WoodenFlesh.spreadSearch) - 1)));
                            BlockEntity blockEntity = level.getBlockEntity(tarPos);
                            if (blockEntity instanceof WoodenFleshBlockEntity) {
                                WoodenFleshBlockEntity woodenFlesh = (WoodenFleshBlockEntity)blockEntity;
                                woodenFlesh.setLogState(logState);
                            }
                            level.playSound(null, pos, AbyssTechSounds.WOODEN_SKIN_CONSUME.get(), SoundSource.BLOCKS);
                        }
                        if (++offX <= 1) continue;
                        offX = -1;
                        if (++offZ <= 1) continue;
                        offZ = -1;
                        if (++offY > 1) break;
                    }
                    if (!logFound) {
                        dropLogItem = true;
                    }
                } else {
                    dropLogItem = true;
                }
                if (dropLogItem) {
                    for (int i = 0; i < 2; ++i) {
                        AbyssTechUtility.ItemSimpleSpawn(level, pos, this.logState.getBlock().asItem());
                    }
                    level.removeBlock(pos, false);
                    level.playSound(null, pos, AbyssTechSounds.WOODEN_SKIN_CONSUME.get(), SoundSource.BLOCKS);
                }
            }
        }
    }

    public void setLogState(BlockState logState) {
        this.logState = logState;
    }
}

