/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssalEngine;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class XpMachineBlockEntity
extends BlockEntity {
    private int xpAmount;
    private final int maxXpAmount = 1000000;
    Random random = new Random();
    private int tickRate = 5;
    private int currentTick = 0;

    public XpMachineBlockEntity(BlockPos pPos, BlockState blockstate) {
        super(AbyssTechBlockEntities.XP_MACHINE_BLOCK_ENTITY.get(), pPos, blockstate);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.xpAmount = pTag.getInt("xp_machine_xp_amount");
        super.loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("xp_machine_xp_amount", this.xpAmount);
        super.saveAdditional(pTag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public void addXpAmount(int amount) {
        this.xpAmount += amount;
    }

    public void setXpAmount(int amount) {
        this.xpAmount = amount;
    }

    public int getXpAmount() {
        return this.xpAmount;
    }

    public int getMaxXpAmount() {
        return 1000000;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            if (this.currentTick >= this.tickRate) {
                BlockEntity blockEntity;
                this.currentTick = 0;
                if (level.getBlockState(pos.below(2)).is(AbyssTechBlocks.ABYSSAL_ENGINE) && ((Boolean)level.getBlockState(pos.below(2)).getValue((Property)AbyssalEngine.hasTube)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof XpMachineBlockEntity) {
                    XpMachineBlockEntity xpMachineBlockEntity = (XpMachineBlockEntity)blockEntity;
                    int currentXpAmount = xpMachineBlockEntity.getXpAmount();
                    int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, -1, true, 2, 4, 6);
                    List xpToMove = level.getEntitiesOfClass(ExperienceOrb.class, new AABB((double)(pos.getX() - searchRadius), (double)(pos.getY() - searchRadius), (double)(pos.getZ() - searchRadius), (double)(pos.getX() + searchRadius), (double)(pos.getY() + searchRadius), (double)(pos.getZ() + searchRadius)));
                    boolean canPlaySound = false;
                    for (Entity entity : xpToMove) {
                        ExperienceOrb experienceOrb;
                        int orbValue;
                        if (!(entity instanceof ExperienceOrb) || currentXpAmount + (orbValue = (experienceOrb = (ExperienceOrb)entity).getValue()) > 1000000) continue;
                        BlockPos tarPos = entity.getOnPos();
                        AbyssTechUtility.drawPathToTarget(level, pos, tarPos, 0.08f, AbyssTechParticles.VIBRANT_BEAM_PARTICLES.get());
                        xpMachineBlockEntity.addXpAmount(orbValue);
                        entity.discard();
                        canPlaySound = true;
                    }
                    if (canPlaySound) {
                        level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, (float)this.random.nextInt(3));
                    }
                }
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            ++this.currentTick;
        }
    }
}

