/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.energy;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class AbyssTechEnergyUtil {
    public static boolean move(BlockPos from, BlockPos to, int amount, Level level) {
        IEnergyStorage fromStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, from, null);
        IEnergyStorage toStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, to, null);
        if (AbyssTechEnergyUtil.canEnergyStorageExtractThisAmount(fromStorage, amount)) {
            return false;
        }
        if (AbyssTechEnergyUtil.canEnergyStorageStillReceiveEnergy(toStorage)) {
            return false;
        }
        int maxAmountToReceive = toStorage.receiveEnergy(amount, true);
        int extractedEnergy = fromStorage.extractEnergy(maxAmountToReceive, false);
        toStorage.receiveEnergy(extractedEnergy, false);
        return true;
    }

    private static boolean canEnergyStorageStillReceiveEnergy(IEnergyStorage toStorage) {
        return toStorage.getEnergyStored() >= toStorage.getMaxEnergyStored() || !toStorage.canReceive();
    }

    private static boolean canEnergyStorageExtractThisAmount(IEnergyStorage fromStorage, int amount) {
        return fromStorage.getEnergyStored() <= 0 || fromStorage.getEnergyStored() < amount || !fromStorage.canExtract();
    }

    public static boolean doesBlockHaveEnergyStorage(BlockPos positionToCheck, Level level) {
        return level.getBlockEntity(positionToCheck) != null && level.getCapability(Capabilities.EnergyStorage.BLOCK, positionToCheck, null) != null;
    }
}

