/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class AbyssTechRenderHelper {
    private static final String nameSpace = "abysstech";

    public static RenderType renderTypeRegisterTranslucent(String renderTypeName, String texturePath) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)texturePath);
        return RenderType.create((String)renderTypeName, (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
    }

    public static RenderType renderTypeRegisterSolid(String renderTypeName, String texturePath) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)texturePath);
        return RenderType.create((String)renderTypeName, (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    }

    public static RenderType renderTypeRegisterGateWay(String renderTypeName, String texturePath) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)texturePath);
        return RenderType.create((String)renderTypeName, (VertexFormat)DefaultVertexFormat.POSITION, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEndPortalShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(texture, false, false).add(texture, false, false).build()).createCompositeState(false));
    }

    public static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }

    public static List<Component> textSplitter(String text, int sliceSize) {
        int take;
        ArrayList<Component> rText = new ArrayList<Component>();
        while (!text.isEmpty() && (take = Math.min(sliceSize, text.length())) != 0) {
            int lastWhitespace = -1;
            for (int i = take - 1; i >= 0; --i) {
                if (!Character.isWhitespace(text.charAt(i))) continue;
                lastWhitespace = i;
                break;
            }
            if (lastWhitespace != -1) {
                rText.add((Component)Component.literal((String)text.substring(0, lastWhitespace + 1)));
                text = text.substring(lastWhitespace + 1);
                continue;
            }
            rText.add((Component)Component.literal((String)text.substring(0, take)));
            text = text.substring(take);
        }
        return rText;
    }
}

