/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssRFGen;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.custom.AbyssRFGenBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AbyssalRfGenRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType STARRY_FIELD_RENDER = AbyssTechRenderHelper.renderTypeRegisterGateWay("starry_field_render", "textures/render/starry_field.png");
    private static final RenderType GAUGE_GREEN_RENDER = AbyssTechRenderHelper.renderTypeRegisterSolid("gauge_green_render", "textures/render/gauge_green.png");

    public AbyssalRfGenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        BlockState state = blockEntity.getBlockState();
        if (state.is(AbyssTechBlocks.ABYSS_RF_GEN) && state.getValue((Property)AbyssRFGen.SEGMENT) == MultiBlockSegment.BOTTOM) {
            this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(this.toRender(false)));
            this.renderGauge(blockEntity, matrix4f, bufferSource.getBuffer(this.toRender(true)));
        }
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof AbyssRFGenBlockEntity) {
            AbyssRFGenBlockEntity abyssRFGenBlockEntity = (AbyssRFGenBlockEntity)blockEntity2;
            float[] transform = abyssRFGenBlockEntity.rendererTranslation();
            this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.4f + transform[0], 0.6f + transform[1], 0.5f, 1.5f, 0.4f + transform[2], 0.6f + transform[3], 0.6f + transform[4], 0.4f + transform[5], Direction.SOUTH, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.4f + transform[0], 0.6f + transform[1], 1.5f, 0.5f, 0.4f + transform[2], 0.6f + transform[3], 0.6f + transform[4], 0.4f + transform[5], Direction.NORTH, 0xF000F0, 15);
        }
    }

    private void renderGauge(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof AbyssRFGenBlockEntity) {
            AbyssRFGenBlockEntity abyssRFGenBlockEntity = (AbyssRFGenBlockEntity)blockEntity2;
            float scaleOne = 0.47f;
            float scaleTwo = 0.53f;
            float yPosTranslation = -0.23f;
            float zHug = 0.44f;
            float offset = 0.3435f;
            float displayHeight = (float)abyssRFGenBlockEntity.getEnergy() * (0.263f / (float)abyssRFGenBlockEntity.getMaxEnergy());
            float displayLength = (float)abyssRFGenBlockEntity.getWarmup() * (0.263f / (float)abyssRFGenBlockEntity.getMaxWarmup());
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - offset, scaleTwo - offset, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + displayHeight, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + zHug, Direction.SOUTH, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + offset, scaleTwo + offset, scaleTwo + yPosTranslation + displayHeight, scaleOne + yPosTranslation, scaleOne - zHug, scaleOne - zHug, scaleOne - zHug, scaleOne - zHug, Direction.NORTH, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + yPosTranslation + displayHeight, scaleOne + yPosTranslation, scaleOne + offset, scaleTwo + offset, scaleTwo + offset, scaleOne + offset, Direction.EAST, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - zHug, scaleOne - zHug, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + displayHeight, scaleOne - offset, scaleTwo - offset, scaleTwo - offset, scaleOne - offset, Direction.WEST, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + offset - displayLength, scaleTwo + offset, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + zHug, Direction.SOUTH, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - offset, scaleTwo - offset + displayLength, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne - zHug, scaleOne - zHug, scaleOne - zHug, scaleOne - zHug, Direction.NORTH, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo + zHug, scaleTwo + zHug, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne - offset, scaleTwo - offset + displayLength, scaleTwo - offset + displayLength, scaleOne - offset, Direction.EAST, 0xF000F0, 15);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - zHug, scaleOne - zHug, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne + offset - displayLength, scaleTwo + offset, scaleTwo + offset, scaleOne + offset - displayLength, Direction.WEST, 0xF000F0, 15);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction, int blockLight, int skyLight) {
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(blockLight, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(blockLight, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(blockLight, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(blockLight, skyLight);
    }

    protected RenderType toRender(boolean gauge) {
        return gauge ? GAUGE_GREEN_RENDER : STARRY_FIELD_RENDER;
    }
}

