/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.AbyssalTome;
import net.quasar.abysstech.block.entity.custom.AbyssalTomeBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

public class AbyssalTomeBlockEntityRenderer
implements BlockEntityRenderer<AbyssalTomeBlockEntity> {
    public AbyssalTomeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AbyssalTomeBlockEntity tome, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (tome.getLevel() != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            ItemStack stack = tome.getItem(0);
            BlockState state = tome.getBlockState();
            if (((Boolean)state.getValue((Property)AbyssalTome.hasItem)).booleanValue()) {
                float yPos = 1.2f;
                float scale = 0.4f;
                float rotation = tome.rotateRenderedItem();
                float bob = tome.bobRenderedItem();
                poseStack.pushPose();
                poseStack.translate(0.5f, yPos + bob, 0.5f);
                poseStack.scale(scale, scale, scale);
                poseStack.rotateAround(Axis.XP.rotationDegrees(0.0f), 0.0f, 0.0f, 0.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, AbyssTechRenderHelper.getLightLevel(tome.getLevel(), tome.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, tome.getLevel(), 1);
                poseStack.popPose();
            }
        }
    }
}

