/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.entity.custom.AmalgamatorBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;
import org.joml.Random;

@OnlyIn(value=Dist.CLIENT)
public class AmalgamatorBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType AMALG_INNER_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("amalg_inner_render", "textures/render/amalg_inner.png");
    private static final RenderType AMALG_OUTER_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("amalg_outer_render", "textures/render/amalg_outer.png");
    Random random = new Random();

    public AmalgamatorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(AMALG_OUTER_RENDER), -0.1f, 1.1f, true);
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(AMALG_INNER_RENDER), -0.01f, 1.01f, false);
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer, float scaleLow, float scaleHigh, boolean outer) {
        AmalgamatorBlockEntity amalgamatorBlockEntity;
        int renderTick;
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof AmalgamatorBlockEntity && (renderTick = (amalgamatorBlockEntity = (AmalgamatorBlockEntity)blockEntity2).getRenderTimer()) > 0) {
            float scaleOne = scaleLow - amalgamatorBlockEntity.getRenderCubeSize(outer) + this.random.nextFloat() * (outer ? 0.12f : 0.08f);
            float scaleTwo = scaleHigh + amalgamatorBlockEntity.getRenderCubeSize(outer) + this.random.nextFloat() * (outer ? 0.12f : 0.08f);
            float yPosTranslation = 1.0f;
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }
}

