/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.entity.custom.DisplacedVoidBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DisplacedVoidBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType STARRY_FIELD = AbyssTechRenderHelper.renderTypeRegisterGateWay("starry_field_render", "textures/render/void_field.png");

    public DisplacedVoidBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(this.renderType()));
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof DisplacedVoidBlockEntity) {
            DisplacedVoidBlockEntity displacedVoidBe = (DisplacedVoidBlockEntity)blockEntity2;
            float scaleOne = 0.4f;
            float scaleTwo = 0.6f;
            float yPosTranslation = -1.2f;
            float bobSpeed = 1.0E-4f;
            int cubeNum = 5;
            int scaleCenter = cubeNum / 2;
            for (int i = 0; i < cubeNum; ++i) {
                float xWobble = i == 0 || i == 3 ? displacedVoidBe.bobRenderedCubeX(bobSpeed) : 0.0f;
                float zWobble = i == 1 || i == 4 ? displacedVoidBe.bobRenderedCubeZ(bobSpeed) : 0.0f;
                float yWobble = displacedVoidBe.bobRenderedCubeY(2.0E-5f);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + xWobble, scaleTwo + xWobble, scaleOne + yPosTranslation + yWobble, scaleTwo + yPosTranslation + yWobble, scaleTwo + zWobble, scaleTwo + zWobble, scaleTwo + zWobble, scaleTwo + zWobble, Direction.SOUTH);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + xWobble, scaleTwo + xWobble, scaleTwo + yPosTranslation + yWobble, scaleOne + yPosTranslation + yWobble, scaleOne + zWobble, scaleOne + zWobble, scaleOne + zWobble, scaleOne + zWobble, Direction.NORTH);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo + xWobble, scaleTwo + xWobble, scaleTwo + yPosTranslation + yWobble, scaleOne + yPosTranslation + yWobble, scaleOne + zWobble, scaleTwo + zWobble, scaleTwo + zWobble, scaleOne + zWobble, Direction.EAST);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + xWobble, scaleOne + xWobble, scaleOne + yPosTranslation + yWobble, scaleTwo + yPosTranslation + yWobble, scaleOne + zWobble, scaleTwo + zWobble, scaleTwo + zWobble, scaleOne + zWobble, Direction.WEST);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + xWobble, scaleTwo + xWobble, scaleOne + yPosTranslation + yWobble, scaleOne + yPosTranslation + yWobble, scaleOne + zWobble, scaleOne + zWobble, scaleTwo + zWobble, scaleTwo + zWobble, Direction.DOWN);
                this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne + xWobble, scaleTwo + xWobble, scaleTwo + yPosTranslation + yWobble, scaleTwo + yPosTranslation + yWobble, scaleTwo + zWobble, scaleTwo + zWobble, scaleOne + zWobble, scaleOne + zWobble, Direction.UP);
                yPosTranslation += 0.6f;
                scaleOne = i < scaleCenter ? scaleOne - 0.1f : scaleOne + 0.1f;
                scaleTwo = i < scaleCenter ? scaleTwo + 0.1f : scaleTwo - 0.1f;
            }
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }

    protected RenderType renderType() {
        return STARRY_FIELD;
    }
}

