/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.EphemeralPot;
import net.quasar.abysstech.block.entity.custom.EphemeralPotBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

public class EphemeralPotBlockEntityRenderer
implements BlockEntityRenderer<EphemeralPotBlockEntity> {
    public EphemeralPotBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EphemeralPotBlockEntity ephemeralPotBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (ephemeralPotBlockEntity.getLevel() != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            ItemStack stack = ephemeralPotBlockEntity.getItem(0);
            BlockState state = ephemeralPotBlockEntity.getBlockState();
            BlockPos pos = ephemeralPotBlockEntity.getBlockPos();
            if (((Boolean)state.getValue((Property)EphemeralPot.hasItem)).booleanValue()) {
                float[] target = ephemeralPotBlockEntity.getGrabbedItemLoc();
                this.renderItem(poseStack, multiBufferSource, itemRenderer, ephemeralPotBlockEntity, stack, target[0] - (float)pos.getX(), target[1] - (float)pos.getY() + ephemeralPotBlockEntity.bobRenderedItem(), target[2] - (float)pos.getZ(), 0.4f, 0.4f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, ephemeralPotBlockEntity.rotateRenderedItem());
            }
        }
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource multiBufferSource, ItemRenderer itemRenderer, EphemeralPotBlockEntity ephemeralPotBlockEntity, ItemStack stack, float transX, float transY, float transZ, float scaleX, float scaleY, float scaleZ, float XPd, float XPx, float XPy, float XPz, float YPd) {
        poseStack.pushPose();
        poseStack.translate(transX, transY, transZ);
        poseStack.scale(scaleX, scaleY, scaleZ);
        poseStack.rotateAround(Axis.XP.rotationDegrees(XPd), XPx, XPy, XPz);
        poseStack.mulPose(Axis.YP.rotationDegrees(YPd));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, AbyssTechRenderHelper.getLightLevel(ephemeralPotBlockEntity.getLevel(), ephemeralPotBlockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, ephemeralPotBlockEntity.getLevel(), 1);
        poseStack.popPose();
    }
}

