/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class EssenceJarBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType ESSENCE_SUBSTANCE_RENDER = AbyssTechRenderHelper.renderTypeRegisterSolid("essence_substance_render", "textures/render/essence_substance.png");

    public EssenceJarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(this.renderType()));
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        EssenceJarBlockEntity essenceJarBlockEntity;
        int essence;
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof EssenceJarBlockEntity && (essence = (essenceJarBlockEntity = (EssenceJarBlockEntity)blockEntity2).getEssence()) > 0) {
            float scaleOne = 0.18f;
            float scaleTwoHeight = 0.18f;
            float scaleTwo = 0.82f;
            float yPosTranslation = -0.1f;
            float yRise = (float)essence * (0.68f / (float)essenceJarBlockEntity.getMaxEssence());
            float yBob = essenceJarBlockEntity.bobSubstance(5.0E-4f);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleTwoHeight + yPosTranslation + yRise + yBob, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }

    protected RenderType renderType() {
        return ESSENCE_SUBSTANCE_RENDER;
    }
}

