/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.custom.MagGlass;
import net.quasar.abysstech.block.entity.custom.MagGlassBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MagGlassBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType LIGHT_ONE_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("abysstech_light_one_render", "textures/render/light_type_one.png");
    private static final RenderType LIGHT_TWO_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("abysstech_light_two_render", "textures/render/light_type_two.png");
    private static final RenderType LIGHT_THREE_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("abysstech_light_three_render", "textures/render/light_type_three.png");
    private static final RenderType LIGHT_FOUR_RENDER = AbyssTechRenderHelper.renderTypeRegisterTranslucent("abysstech_light_four_render", "textures/render/light_type_four.png");

    public MagGlassBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        int lightType = 0;
        if (blockEntity instanceof MagGlassBlockEntity) {
            MagGlassBlockEntity magGlassBlock = (MagGlassBlockEntity)((Object)blockEntity);
            lightType = magGlassBlock.getLightType();
        }
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(lightType == 1 ? LIGHT_ONE_RENDER : (lightType == 2 ? LIGHT_TWO_RENDER : (lightType == 3 ? LIGHT_THREE_RENDER : LIGHT_FOUR_RENDER))), 0.1f, 0.9f);
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer, float scaleLow, float scaleHigh) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof MagGlassBlockEntity) {
            MagGlassBlockEntity magBe = (MagGlassBlockEntity)blockEntity2;
            BlockState magState = magBe.getBlockState();
            if (magBe.getLightType() != 0 && magBe.getLightAmount() != 0) {
                float scaleOne = scaleLow;
                float scaleTwo = scaleHigh;
                float yPosTranslation = 0.0f;
                float distScale = magBe.getLightDist();
                switch ((Direction)magState.getValue((Property)MagGlass.FACING)) {
                    case NORTH: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne - distScale, scaleOne - distScale, scaleOne - distScale, scaleOne - distScale, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne - distScale, scaleTwo, scaleTwo, scaleOne - distScale, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne - distScale, scaleTwo, scaleTwo, scaleOne - distScale, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne - distScale, scaleOne - distScale, scaleTwo, scaleTwo, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne - distScale, scaleOne - distScale, Direction.UP);
                        break;
                    }
                    case SOUTH: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo + distScale, scaleTwo + distScale, scaleTwo + distScale, scaleTwo + distScale, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleTwo + distScale, scaleTwo + distScale, scaleOne, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne, scaleTwo + distScale, scaleTwo + distScale, scaleOne, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo + distScale, scaleTwo + distScale, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo + distScale, scaleTwo + distScale, scaleOne, scaleOne, Direction.UP);
                        break;
                    }
                    case EAST: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo + distScale, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo + distScale, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo + distScale, scaleTwo + distScale, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo + distScale, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo + distScale, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
                        break;
                    }
                    case WEST: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - distScale, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - distScale, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - distScale, scaleOne - distScale, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - distScale, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne - distScale, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
                        break;
                    }
                    case UP: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + distScale, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + distScale, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleTwo + yPosTranslation + distScale, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
                        break;
                    }
                    default: {
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation - distScale, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation - distScale, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation - distScale, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation - distScale, scaleTwo + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation - distScale, scaleOne + yPosTranslation - distScale, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
                        this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
                    }
                }
            }
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }
}

