/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.MixableFourBlockStack;
import net.quasar.abysstech.block.entity.custom.MixableFourBlockStackBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

public class MixableFourBlockStackBlockEntityRenderer
implements BlockEntityRenderer<MixableFourBlockStackBlockEntity> {
    public MixableFourBlockStackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MixableFourBlockStackBlockEntity mixableBe, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (mixableBe.getLevel() != null) {
            int rotationFromFacing;
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            ItemStack[] items = new ItemStack[]{mixableBe.getItem(0), mixableBe.getItem(1), mixableBe.getItem(2), mixableBe.getItem(3)};
            BlockState state = mixableBe.getBlockState();
            int itemIn = (Integer)state.getValue((Property)MixableFourBlockStack.itemsIn);
            switch ((Direction)state.getValue((Property)MixableFourBlockStack.FACING)) {
                case NORTH: {
                    int n = 0;
                    break;
                }
                case EAST: {
                    int n = 90;
                    break;
                }
                case SOUTH: {
                    int n = 180;
                    break;
                }
                default: {
                    int n = rotationFromFacing = 270;
                }
            }
            if (itemIn > 0) {
                float yTranslation = 0.2f;
                int rotationTranslation = -3;
                for (int i = 0; i < itemIn; ++i) {
                    poseStack.pushPose();
                    poseStack.translate(0.5f, yTranslation, 0.5f);
                    poseStack.scale(1.25f, 1.25f, 1.25f);
                    poseStack.rotateAround(Axis.XP.rotationDegrees(90.0f), 0.0f, 0.0f, 0.0f);
                    poseStack.mulPose(Axis.ZP.rotationDegrees((float)(rotationFromFacing + rotationTranslation)));
                    itemRenderer.renderStatic(items[i], ItemDisplayContext.FIXED, AbyssTechRenderHelper.getLightLevel(mixableBe.getLevel(), mixableBe.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, mixableBe.getLevel(), 1);
                    poseStack.popPose();
                    yTranslation += 0.25f;
                    rotationTranslation += 2;
                }
            }
        }
    }
}

